/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.blogs;

import com.kwoksys.action.blogs.PostCommentAddForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.auth.core.BlogPostAccess;
import com.kwoksys.biz.blogs.BlogService;
import com.kwoksys.biz.blogs.dto.BlogPost;
import com.kwoksys.biz.blogs.dto.BlogPostComment;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class PostDetailAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        AccessUser user = this.requestContext.getUser();
        this.getBaseForm(PostCommentAddForm.class);
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        Integer postId = this.requestContext.getParameter("postId");
        BlogPost blogPost = blogService.getPost(postId);
        Object[] args = new Object[]{AdminUtils.getSystemUsername(this.requestContext, blogPost.getCreator()), blogPost.getCreationDate()};
        String postCommentCount = Localizer.getText(this.requestContext, "blogs.postDetail.commentHeader", new Object[]{blogPost.getPostCommentCount()});
        boolean postAllowComment = blogPost.isPostAllowComment();
        ArrayList postCommentList = new ArrayList();
        for (BlogPostComment comment : blogService.getPostComments(new QueryCriteria(), blogPost.getId())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("commentDescription", HtmlUtils.formatMultiLineDisplay(comment.getCommentDescription()));
            Link link2 = new Link(this.requestContext);
            link2.setTitle(Localizer.getText(this.requestContext, "blogs.colData.comment_creator", (Object[])new String[]{AdminUtils.getSystemUsername(this.requestContext, comment.getCreator()), comment.getCreationDate()}));
            map.put("commentCreator", Image.getInstance().getBlogComment() + link2.getString());
            postCommentList.add(map);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("postTitle", blogPost.getPostTitle());
        standardTemplate.setAttribute("postBody", HtmlUtils.formatMultiLineDisplay(blogPost.getPostBody()));
        standardTemplate.setAttribute("postCreator", Localizer.getText(this.requestContext, "blogs.colName.creation_info", args));
        standardTemplate.setAttribute("postCommentCount", postCommentCount);
        standardTemplate.setAttribute("postCommentList", postCommentList);
        if (postAllowComment && Access.hasPermission(user, AppPaths.BLOG_POST_COMMENT_ADD_2)) {
            standardTemplate.setPathAttribute("postCommentPath", AppPaths.BLOG_POST_COMMENT_ADD_2 + "?postId=" + blogPost.getId());
        }
        standardTemplate.setAttribute("postAllowComment", postAllowComment);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        if (Access.hasPermission(user, AppPaths.BLOG_POST_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.BLOG_POST_LIST);
            link.setTitleKey("portal.cmd.blogPostList");
            header.addHeaderCmds(link);
        }
        if (user.hasPermission(AppPaths.BLOG_POST_EDIT)) {
            link = new Link(this.requestContext);
            if (BlogPostAccess.hasEditPermission(user, blogPost)) {
                link.setAjaxPath(AppPaths.BLOG_POST_EDIT + "?postId=" + blogPost.getId());
            } else {
                link.setInlineImage(Image.getInstance().getInfo(Localizer.getText(this.requestContext, "blogs.postEdit.noPermission")));
            }
            link.setTitleKey("blogs.postEdit.header");
            header.addHeaderCmds(link);
        }
        if (user.hasPermission(AppPaths.BLOG_POST_DELETE)) {
            link = new Link(this.requestContext);
            if (BlogPostAccess.hasDeletePermission(user, blogPost)) {
                link.setAjaxPath(AppPaths.BLOG_POST_DELETE + "?postId=" + blogPost.getId());
            } else {
                link.setInlineImage(Image.getInstance().getInfo(Localizer.getText(this.requestContext, "blogs.postDelete.noPermission")));
            }
            link.setTitleKey("blogs.postDelete.header");
            header.addHeaderCmds(link);
        }
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }
}

