/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.blogs;

import com.kwoksys.action.blogs.PostForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.BlogPostAccess;
import com.kwoksys.biz.blogs.BlogService;
import com.kwoksys.biz.blogs.core.BlogUtils;
import com.kwoksys.biz.blogs.dao.BlogQueries;
import com.kwoksys.biz.blogs.dto.BlogPost;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.AccessDeniedException;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import java.util.ArrayList;

public class PostEditAction
extends Action2 {
    public String edit() throws Exception {
        AccessUser user = this.requestContext.getUser();
        PostForm actionForm = this.getBaseForm(PostForm.class);
        actionForm.setId("postEditForm");
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        BlogPost post = blogService.getPost(actionForm.getPostId());
        if (!BlogPostAccess.hasEditPermission(user, post)) {
            throw new AccessDeniedException();
        }
        if (!actionForm.isResubmit()) {
            actionForm.setPost(post);
        }
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(BlogQueries.getOrderByColumn("category_name"));
        ArrayList<LabelValueBean> categoryIdOptions = new ArrayList<LabelValueBean>();
        for (Category category : blogService.getCategories(queryCriteria)) {
            categoryIdOptions.add(new LabelValueBean(category.getName(), String.valueOf(category.getId())));
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.BLOG_POST_EDIT_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.BLOG_POST_DETAIL + "?postId=" + post.getId()).getString());
        this.request.setAttribute("postAllowCommentOptions", BlogUtils.getCommentOptions(this.requestContext));
        this.request.setAttribute("postCategoryIdOptions", categoryIdOptions);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("blogs.postEdit.header");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        AccessUser user = this.requestContext.getUser();
        PostForm actionForm = this.saveActionForm(new PostForm());
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        BlogPost post = blogService.getPost(actionForm.getPostId());
        post.setId(actionForm.getPostId());
        post.setPostTitle(actionForm.getPostTitle());
        post.setPostBody(actionForm.getPostBody());
        post.setPostAllowComment(actionForm.getPostAllowComment());
        post.setCategoryId(actionForm.getCategoryId());
        if (!BlogPostAccess.hasEditPermission(user, post)) {
            throw new AccessDeniedException();
        }
        ActionMessages errors = blogService.editPost(post);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.BLOG_POST_EDIT + "?postId=" + post.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.BLOG_POST_DETAIL + "?postId=" + post.getId());
    }
}

