/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.blogs;

import com.kwoksys.action.blogs.PostSearchForm;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.blogs.BlogService;
import com.kwoksys.biz.blogs.core.BlogPostSearch;
import com.kwoksys.biz.blogs.dao.BlogQueries;
import com.kwoksys.biz.blogs.dto.BlogPost;
import com.kwoksys.biz.portal.PortalUtils;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.HashMap;

public class PostListAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        PostSearchForm actionForm = this.getSessionBaseForm(PostSearchForm.class);
        AccessUser user = this.requestContext.getUser();
        String cmd = this.requestContext.getParameterString("cmd");
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getBlogsNumPosts());
        Integer categoryId = this.requestContext.getParameter("categoryId");
        int rowStart = 0;
        if (!cmd.isEmpty()) {
            this.request.getSession().setAttribute("blogPostsRowStart", (Object)rowStart);
        } else {
            rowStart = SessionManager.getOrSetAttribute(this.requestContext, "rowStart", "blogPostsRowStart", rowStart);
        }
        BlogPostSearch blogPostSearch = new BlogPostSearch(this.requestContext, "BLOG_POST_SEARCH_CRITERIA_MAP");
        blogPostSearch.prepareMap(actionForm);
        QueryCriteria queryCriteria = new QueryCriteria(blogPostSearch);
        queryCriteria.addSortColumn(BlogQueries.getOrderByColumn("creation_date"), "desc");
        queryCriteria.setLimit(rowLimit, rowStart);
        boolean hasBlogDetailAccess = Access.hasPermission(user, AppPaths.BLOG_POST_DETAIL);
        ArrayList posts = new ArrayList();
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        int rowCount = blogService.getPostCount(queryCriteria);
        if (rowCount != 0) {
            for (BlogPost post : blogService.getPosts(queryCriteria)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("postTitle", post.getPostTitle());
                map.put("postBody", PortalUtils.truncateBodyTextOnList(post.getPostBody()));
                Object[] args = new Object[]{AdminUtils.getSystemUsername(this.requestContext, post.getCreator()), post.getCreationDate()};
                map.put("postCreator", Localizer.getText(this.requestContext, "blogs.colName.creation_info", args));
                String postCategoryPath = new Link(this.requestContext).setAjaxPath(AppPaths.BLOG_POST_LIST + "?cmd=search&categoryId=" + post.getCategoryId()).setTitle(post.getCategoryName()).getString();
                map.put("postCategoryPath", Localizer.getText(this.requestContext, "blogs.colName.category_info", new Object[]{postCategoryPath}));
                int countComment = post.getPostCommentCount();
                Link link2 = new Link(this.requestContext);
                link2.setTitle(Localizer.getText(this.requestContext, "blogs.postList.commentPath", new Object[]{countComment}));
                if (hasBlogDetailAccess && countComment != 0) {
                    link2.setAppPath(AppPaths.BLOG_POST_DETAIL + "?postId=" + post.getId() + "#comment");
                }
                map.put("titleLink", new Link(this.requestContext).setTitle(post.getPostTitle()).setStyleClass("h2").setAjaxPath(AppPaths.BLOG_POST_DETAIL + "?postId=" + post.getId()).getString());
                map.put("permaLink", new Link(this.requestContext).setTitleKey("blogs.postList.permalink").setAjaxPath(AppPaths.BLOG_POST_DETAIL + "?postId=" + post.getId()).getString());
                map.put("postCommentPath", link2.getString());
                posts.add(map);
            }
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("postList", posts);
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setFirstText(Localizer.getText(this.requestContext, "blogs.postList.recordsNav.first"));
        nav.setPath(AppPaths.BLOG_POST_LIST + "?rowStart=");
        standardTemplate.setAttribute("recordsNavigationTemplate", nav);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleClassNoLine();
        if (categoryId != 0) {
            Category category = blogService.getCategory(categoryId);
            header.setTitleKey("blogs.postList.headerWithCategory", new String[]{category.getName()});
        } else {
            header.setTitleKey("blogs.postList.header");
        }
        if (Access.hasPermission(user, AppPaths.BLOG_POST_ADD)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.BLOG_POST_ADD + "?categoryId=" + categoryId);
            link.setTitleKey("portal.cmd.blogPostAdd");
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.BLOG_POST_LIST_RSS)) {
            link = new Link(this.requestContext);
            link.setAppPath(AppPaths.BLOG_POST_LIST_RSS);
            link.setTitleKey("portal.cmd.rssFeedSubscribe");
            link.setInlineImage(Image.getInstance().getRssFeedIcon());
            header.addHeaderCmds(link);
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

