/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.blogs;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.blogs.BlogService;
import com.kwoksys.biz.blogs.core.BlogPostSearch;
import com.kwoksys.biz.blogs.dao.BlogQueries;
import com.kwoksys.biz.blogs.dto.BlogPost;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.parsers.rss.RssModel;
import com.kwoksys.framework.parsers.rss.RssModelHelper;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;

public class PostListRssAction
extends Action2 {
    public String execute() throws Exception {
        int rowStart = this.requestContext.getParameter("rowStart", 0);
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getBlogsNumPosts());
        String appPath = ConfigManager.system.getAppUrl() + AppPaths.ROOT;
        RssModel rssModel = new RssModel();
        rssModel.setTitle(Localizer.getText(this.requestContext, "blogs.postList.header"));
        rssModel.setLink(appPath);
        rssModel.setDescription(Localizer.getText(this.requestContext, "rss.description"));
        rssModel.setLanguage("en-us");
        BlogPostSearch blogPostSearch = new BlogPostSearch();
        blogPostSearch.put("blogPostListPage", "");
        QueryCriteria queryCriteria = new QueryCriteria(blogPostSearch);
        queryCriteria.addSortColumn(BlogQueries.getOrderByColumn("creation_date"), "desc");
        queryCriteria.setLimit(rowLimit, rowStart);
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        for (BlogPost post : blogService.getPosts(queryCriteria)) {
            RssModel.Item item = new RssModel.Item(rssModel);
            item.setTitle(post.getPostTitle());
            String postPermalinkpath = appPath + AppPaths.BLOG_POST_DETAIL + "?postId=" + post.getId();
            item.setLink(postPermalinkpath);
            rssModel.addItem(item);
        }
        this.response.setContentType("text/xml");
        RssModelHelper helper = new RssModelHelper();
        helper.modelToXml(rssModel);
        this.response.getWriter().print(helper.getXmlString());
        return null;
    }
}

