/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.common.calendar;

import com.kwoksys.biz.admin.core.CalendarUtils;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CalendarAction {
    private final List<Map<String, Object>> calendarList = new ArrayList<Map<String, Object>>();
    private final List<String> weekdayList = new ArrayList<String>();
    private final String prevPath;
    private final String nextPath;

    public CalendarAction() {
        this.prevPath = null;
        this.nextPath = null;
    }

    public void setRequest(RequestContext requestContext) {
        GregorianCalendar calendar = new GregorianCalendar();
        int year = calendar.get(1);
        int date = 1;
        if (CalendarUtils.isValidYear(requestContext.getRequest().getParameter("year"))) {
            year = Integer.parseInt(requestContext.getRequest().getParameter("year"));
        }
        Object[] argsMonthYear = new Object[]{String.valueOf(year)};
        for (int month = 0; month < 12; ++month) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", Localizer.getText(requestContext, "webCalendar.monthYear." + month, argsMonthYear));
            calendar = new GregorianCalendar(year, month, date);
            ArrayList dayList = new ArrayList();
            int numPads = calendar.get(7) - 1;
            for (int mDate = 1; mDate <= numPads; ++mDate) {
                HashMap<String, String> dayMap = new HashMap<String, String>();
                dayMap.put("date", "&nbsp;");
                dayList.add(dayMap);
            }
            int numDays = ((Calendar)calendar).getActualMaximum(5);
            for (int mDate = 1; mDate <= numDays; ++mDate) {
                HashMap<String, Integer> dayMap = new HashMap<String, Integer>();
                dayMap.put("date", mDate);
                dayList.add(dayMap);
            }
            map.put("dayList", dayList);
            this.calendarList.add(map);
        }
        for (int weekday = 0; weekday < 7; ++weekday) {
            this.weekdayList.add(Localizer.getText(requestContext, "webCalendar.shortDay." + weekday));
        }
    }

    public List<Map<String, Object>> getCalendarList() {
        return this.calendarList;
    }

    public List<String> getWeekdayList() {
        return this.weekdayList;
    }

    public String getPrevPath() {
        return this.prevPath;
    }

    public String getNextPath() {
        return this.nextPath;
    }
}

