/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.common.template;

import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class ActionErrorsTemplate
extends BaseTemplate {
    private boolean showRequiredFieldMsg;
    private boolean hideErrorTitle = false;
    private String message;

    public ActionErrorsTemplate() {
        super(ActionErrorsTemplate.class);
    }

    @Override
    public void init() {
    }

    @Override
    public void applyTemplate() throws Exception {
        ActionMessages errors = (ActionMessages)this.requestContext.getSession().getAttribute("_messages");
        if (this.showRequiredFieldMsg) {
            String requiredFieldMsg = Localizer.getText(this.requestContext, "requiredFieldBlurb");
            this.message = this.message == null ? requiredFieldMsg : this.message + " " + requiredFieldMsg;
        }
        if (errors != null) {
            this.requestContext.getSession().removeAttribute("_messages");
            if (this.requestContext.hasErrors()) {
                LinkedHashSet<String> errorMessages = new LinkedHashSet<String>();
                LinkedHashSet<String> errorFormFields = new LinkedHashSet<String>();
                Iterator propIter = errors.properties();
                while (propIter.hasNext()) {
                    String key = (String)propIter.next();
                    errorFormFields.add(key);
                    Iterator errorIter = errors.get(key);
                    while (errorIter.hasNext()) {
                        ActionMessage actionMessage = (ActionMessage)errorIter.next();
                        if (actionMessage.isEncodeHtml()) {
                            errorMessages.add(HtmlUtils.encode(Localizer.getText(this.requestContext, actionMessage.getKey(), actionMessage.getValues())));
                            continue;
                        }
                        errorMessages.add(Localizer.getText(this.requestContext, actionMessage.getKey(), actionMessage.getValues()));
                    }
                }
                this.requestContext.getRequest().setAttribute("_messages", errorMessages);
                this.requestContext.getRequest().setAttribute("_formErrorFields", errorFormFields);
            }
        }
    }

    @Override
    public String getJspPath() {
        return "/jsp/common/template/ActionMessages.jsp";
    }

    public void setShowRequiredFieldMsg(boolean showRequiredFieldMsg) {
        this.showRequiredFieldMsg = showRequiredFieldMsg;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessageKey(String key) {
        this.setMessageKey(key, null);
    }

    public void setMessageKey(String key, String[] params) {
        this.message = Localizer.getText(this.requestContext, key, (Object[])params);
        if (this.message == null) {
            this.message = key;
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isHideErrorTitle() {
        return this.hideErrorTitle;
    }

    public ActionErrorsTemplate setHideErrorTitle(boolean hideErrorTitle) {
        this.hideErrorTitle = hideErrorTitle;
        return this;
    }
}

