/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.common.template;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeGroup;
import com.kwoksys.biz.base.BaseObject;
import com.kwoksys.biz.base.BaseObjectForm;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.session.CookieManager;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import com.kwoksys.framework.util.CustomFieldFormatter;
import com.kwoksys.framework.util.HtmlUtils;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CustomFieldsTemplate
extends BaseTemplate {
    private Map<String, List> customFields = new TreeMap<String, List>();
    private Integer objectTypeId;
    private Integer objectId;
    private Integer objectAttrTypeId;
    private boolean expandCustomFields;
    private BaseObjectForm form;
    private boolean editPage = false;
    private boolean isPartialTable = false;
    private boolean showDefaultHeader = true;
    private String toggleLink;
    private boolean allowToggle = true;

    public CustomFieldsTemplate() {
        super(CustomFieldsTemplate.class);
    }

    @Override
    public void init() {
    }

    @Override
    public void applyTemplate() throws Exception {
        Collection<Attribute> attrs;
        String customFieldsExpand = CookieManager.getCustomFieldsExpand(this.request.getCookies());
        this.expandCustomFields = !customFieldsExpand.isEmpty() ? customFieldsExpand.equals("true") : ConfigManager.app.isLoadCustomFields();
        if (!this.isEditPage()) {
            this.toggleLink = new Link(this.requestContext).setInlineImage(Image.getInstance().getExpandIcon(this.requestContext, "common.action.ToggleExpand", "customFieldToggleImage", this.getToggleJavascript())).getString();
        }
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        Map<Integer, Object> valueMap = null;
        if (this.objectId != null) {
            valueMap = adminService.getCustomAttributeValueMap(this.objectTypeId, this.objectId);
        }
        if (!(attrs = new AttributeManager(this.requestContext).getCustomFieldMap(this.objectTypeId).values()).isEmpty()) {
            List<Integer> mappedAttrIds = adminService.getSavedAttributeFieldTypes(this.objectAttrTypeId);
            Map<Integer, AttributeGroup> groupMap = new CacheManager(this.requestContext).getCustomAttrGroupsCache(this.objectTypeId);
            for (Attribute attr : attrs) {
                AttributeGroup group;
                String key;
                ArrayList list;
                String value = StringUtils.replaceNull(this.getFieldValue(valueMap, attr));
                if (this.objectAttrTypeId != null && !mappedAttrIds.contains(attr.getId()) && value.isEmpty()) continue;
                if (this.form != null && this.form.isResubmit()) {
                    value = this.form.getCustomValues() != null ? this.form.getCustomValues().get(attr.getId()).getAttributeValue() : this.requestContext.getParameterString("attrId" + attr.getId());
                }
                HashMap<String, Object> attrMap = new HashMap<String, Object>();
                attrMap.put("attr", attr);
                attrMap.put("value", value);
                if (this.isEditPage()) {
                    attrMap.put("attrId" + attr.getId(), HtmlUtils.encode(value));
                    if (Attribute.supportOptions(attr.getType())) {
                        ArrayList<LabelValueBean> newOptions = new ArrayList<LabelValueBean>();
                        List<String> currentOptions = attr.getAttributeOptions();
                        if (currentOptions.contains("_blank")) {
                            newOptions.add(new SelectOneLabelValueBean(this.requestContext));
                        }
                        if (!value.isEmpty() && !currentOptions.contains(value)) {
                            value = HtmlUtils.encode(value);
                            newOptions.add(new LabelValueBean(value, value));
                        }
                        for (String string : currentOptions) {
                            if (string.equals("_blank")) continue;
                            string = HtmlUtils.encode(string);
                            newOptions.add(new LabelValueBean(string, string));
                        }
                        attrMap.put("attrOptions", newOptions);
                    }
                } else if (!value.isEmpty() && !attr.getUrl().isEmpty()) {
                    value = this.getFieldTextValue(valueMap, attr);
                    String[] strings = attr.getUrl().split("\\|");
                    String attrLinkUrl = strings[0].replace("${CUSTOM_FIELD_VALUE}", value);
                    String attrLinkName = strings.length == 2 ? strings[1].replace("${CUSTOM_FIELD_VALUE}", value) : attrLinkUrl;
                    attrMap.put("attrLink", " [" + new Link(this.requestContext).setExternalPath(attrLinkUrl).setTitle(attrLinkName).getString() + "]");
                }
                if ((list = this.customFields.get(key = AdminUtils.getAttributeGroupKey(this.showDefaultHeader ? this.requestContext : null, group = groupMap.get(attr.getAttributeGroupId())))) == null) {
                    list = new ArrayList();
                    this.customFields.put(key, list);
                }
                list.add(attrMap);
            }
        }
    }

    @Override
    public String getJspPath() {
        if (this.allowToggle) {
            return "/jsp/common/template/CustomFieldsTableToggle.jsp";
        }
        return "/jsp/common/template/CustomFields.jsp";
    }

    private String getFieldValue(Map valueMap, Attribute attr) {
        if (valueMap == null) {
            return "";
        }
        Object fieldValue = valueMap.get(attr.getId());
        CustomFieldFormatter formatter = new CustomFieldFormatter(this.requestContext, attr, fieldValue);
        formatter.setEditPage(this.editPage);
        return formatter.getAttributeValue();
    }

    public String getFieldTextValue(Map valueMap, Attribute attr) {
        if (valueMap == null) {
            return "";
        }
        Object fieldValue = valueMap.get(attr.getId());
        CustomFieldFormatter formatter = new CustomFieldFormatter(this.requestContext, attr, fieldValue);
        return formatter.getAttributeTextValue();
    }

    public void setObject(BaseObject baseObject) {
        this.objectTypeId = baseObject.getObjectTypeId();
        this.objectId = baseObject.getId();
    }

    public String getDatePattern() {
        return ConfigManager.system.getDateFormat();
    }

    public Map<String, List> getCustomFields() {
        return this.customFields;
    }

    public Integer getObjectTypeId() {
        return this.objectTypeId;
    }

    public void setObjectTypeId(Integer objectTypeId) {
        this.objectTypeId = objectTypeId;
    }

    public Integer getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Integer objectId) {
        this.objectId = objectId;
    }

    public boolean isEditPage() {
        return this.editPage;
    }

    public void setObjectAttrTypeId(Integer objectAttrTypeId) {
        this.objectAttrTypeId = objectAttrTypeId;
    }

    public void setPartialTable(boolean partialTable) {
        this.isPartialTable = partialTable;
    }

    public boolean isPartialTable() {
        return this.isPartialTable;
    }

    public void setShowDefaultHeader(boolean showDefaultHeader) {
        this.showDefaultHeader = showDefaultHeader;
    }

    public boolean isExpandCustomFields() {
        return this.expandCustomFields;
    }

    public void setForm(BaseObjectForm form) {
        this.form = form;
        this.editPage = true;
    }

    public String getToggleLink() {
        return this.toggleLink;
    }

    public String getToggleJavascript() {
        return "App.toggleCustomFields('customFields', '" + Localizer.getText(this.requestContext, "common.action.ToggleCollapse") + "', '" + Localizer.getText(this.requestContext, "common.action.ToggleExpand") + "');";
    }

    public void setAllowToggle(boolean allowToggle) {
        this.allowToggle = allowToggle;
    }
}

