/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.common.template;

import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.FeatureManager;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.license.LicenseManager;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.properties.PropertiesManager;
import com.kwoksys.framework.ui.Link;

public class FooterTemplate
extends BaseTemplate {
    private String reportIssuePath;
    private String timezone;
    private String copyrightNotice;
    private String edition;
    private String siteLink;

    public FooterTemplate() {
        super(FooterTemplate.class);
    }

    @Override
    public void init() {
    }

    @Override
    public void applyTemplate() {
        boolean issueGuestSubmitFooterEnabled = FeatureManager.isIssueGuestSubmitFooterEnabled();
        if (issueGuestSubmitFooterEnabled) {
            this.reportIssuePath = new Link(this.requestContext).setAjaxPath(AppPaths.ISSUE_PLUGIN_ADD).setTitleKey("issuePlugin.issueAdd.title").getString();
        }
        this.timezone = Localizer.getText(this.requestContext, "admin.config.timezone." + ConfigManager.system.getTimezoneLocalString());
        this.copyrightNotice = ConfigManager.system.getCompanyFooterNotes();
        if (this.copyrightNotice.isEmpty()) {
            this.copyrightNotice = Localizer.getText(this.requestContext, "core.template.footer.copyright");
        }
        this.edition = LicenseManager.getContentKey();
        this.siteLink = new Link(this.requestContext).setExternalPath("http://www.kwoksys.com").setTitle(Localizer.getText(this.requestContext, "common.app.name") + " " + PropertiesManager.getVersion()).getString();
    }

    @Override
    public String getJspPath() {
        return "/jsp/common/template/Footer.jsp";
    }

    public String getReportIssuePath() {
        return this.reportIssuePath;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getCopyrightNotice() {
        return this.copyrightNotice;
    }

    public String getEdition() {
        return this.edition;
    }

    public String getSiteLink() {
        return this.siteLink;
    }
}

