/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.common.template;

import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.util.StringUtils;

public class HeaderSimpleTemplate
extends BaseTemplate {
    private String pageTitleText;
    private String titleText;
    private String themeTitleText;
    private String fontSize;
    private String jqueryDateFormat;
    private String sessionTheme;

    public HeaderSimpleTemplate() {
        super(HeaderSimpleTemplate.class);
    }

    public HeaderSimpleTemplate(Class clazz) {
        super(clazz);
    }

    @Override
    public void init() {
    }

    @Override
    public void applyTemplate() throws Exception {
        this.sessionTheme = SessionManager.getAppSessionTheme(this.request.getSession());
        this.jqueryDateFormat = ConfigManager.system.getDateFormat().toLowerCase().replace("yy", "y");
        if (StringUtils.isEmpty(this.fontSize)) {
            this.fontSize = SessionManager.getAttribute(this.request, "FONT_SIZE", String.valueOf(ConfigManager.system.getFontOptions()[1]));
        }
        this.pageTitleText = AdminUtils.getTitleText(this.requestContext, this.pageTitleText == null ? this.titleText : this.pageTitleText);
    }

    public String getCustomStylesheet() {
        return ConfigManager.system.getSytlesheet();
    }

    public String getThemeStylePath() {
        return AppPaths.getInstance().getThemeCss(this.sessionTheme);
    }

    public String getJqueryDateFormat() {
        return this.jqueryDateFormat;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setTitleText(String titleText) {
        this.titleText = titleText;
    }

    public void setTitleKey(String titleKey) {
        this.titleText = Localizer.getText(this.requestContext, titleKey);
    }

    public void setEditTitleKey(String titleKey) {
        String title = Localizer.getText(this.requestContext, titleKey);
        this.titleText = Localizer.getText(this.requestContext, "admin.config.app.edit", (Object[])new String[]{title});
    }

    public void setTitleKey(String titleKey, String[] titleKeyParams) {
        this.titleText = Localizer.getText(this.requestContext, titleKey, (Object[])titleKeyParams);
    }

    public void setPageTitleKey(String pageTitleKey) {
        this.pageTitleText = Localizer.getText(this.requestContext, pageTitleKey);
    }

    public void setPageTitleKey(String pageTitleKey, Object[] pageTitleParams) {
        this.pageTitleText = Localizer.getText(this.requestContext, pageTitleKey, pageTitleParams);
    }

    public String getPageTitleText() {
        return this.pageTitleText;
    }

    public String getTitleText() {
        return this.titleText;
    }

    public String getThemeTitleText() {
        return this.themeTitleText;
    }

    public void setThemeTitleText(String themeTitleText) {
        this.themeTitleText = themeTitleText;
    }
}

