/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.common.template;

import com.kwoksys.action.common.template.HeaderSimpleTemplate;
import com.kwoksys.action.common.template.NotificationBarTemplate;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.portal.dto.Site;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Modules;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HeaderTemplate
extends HeaderSimpleTemplate {
    private String titleClass;
    private String sectionText;
    private List<Map<String, String>> moduleTabs = new ArrayList<Map<String, String>>();
    private List<Link> headerCmds = new ArrayList<Link>();
    private List<Link> navLinks = new ArrayList<Link>();
    private Integer moduleId;
    private String appLogoPath;
    private String notifyMessage;
    private String navCmds;
    private String userMessage;
    private String onloadJavascript;

    public HeaderTemplate() {
        super(HeaderTemplate.class);
    }

    @Override
    public void init() {
    }

    @Override
    public void applyTemplate() throws Exception {
        String sessionNotifyMessage;
        Link link;
        super.applyTemplate();
        AccessUser user = this.requestContext.getUser();
        this.moduleId = this.requestContext.getModuleId();
        for (String string : ConfigManager.system.getModuleTabs()) {
            Integer thisModuleId = Integer.parseInt(string);
            String modulePath = Modules.getModulePath(thisModuleId);
            if (!user.hasPermission(modulePath)) continue;
            HashMap<String, String> moduleMap = new HashMap<String, String>();
            moduleMap.put("modulePath", new Link(this.requestContext).setAjaxPath(modulePath).setTitleKey("core.moduleName." + string).setId("headerModule" + thisModuleId).setStyleClass("themeBorder").getString());
            this.moduleTabs.add(moduleMap);
        }
        List<Site> sites = new CacheManager(this.requestContext).getModuleTabsCache();
        for (Site site : sites) {
            HashMap<String, String> moduleMap = new HashMap<String, String>();
            moduleMap.put("modulePath", new Link(this.requestContext).setPath(site.getPath()).setTitle(site.getName()).setStyleClass("themeBorder").getString());
            this.moduleTabs.add(moduleMap);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (user.isLoggedOn()) {
            Object[] args = new Object[]{HtmlUtils.encode(AdminUtils.getSystemUsername(this.requestContext, user))};
            arrayList.add(Localizer.getText(this.requestContext, "core.template.header.welcomeUser", args));
            if (!ConfigManager.auth.isBasicAuth()) {
                Link link2 = new Link(this.requestContext).setAppPath(AppPaths.AUTH_LOGOUT).setInlineImage(Image.getInstance().getLogout()).setTitleKey("core.template.header.logout");
                arrayList.add(link2.getString());
            }
        }
        if (user.hasPermission(AppPaths.USER_PREF_INDEX)) {
            link = new Link(this.requestContext).setAjaxPath(AppPaths.USER_PREF_INDEX).setInlineImage(Image.getInstance().getPreference()).setTitleKey("core.template.header.userPreference");
            arrayList.add(link.getString());
        }
        if (user.hasPermission(AppPaths.ADMIN_INDEX)) {
            link = new Link(this.requestContext).setAjaxPath(AppPaths.ADMIN_INDEX).setInlineImage(Image.getInstance().getAdminIcon()).setTitleKey("admin.index.title");
            arrayList.add(link.getString());
        }
        this.userMessage = StringUtils.join(arrayList, " | ");
        if (!this.navLinks.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Link link3 : this.navLinks) {
                if (sb.length() != 0) {
                    sb.append(" / ");
                }
                sb.append(link3.getString());
            }
            this.navCmds = sb.toString();
        }
        link = new Link(this.requestContext).setExternalPath(ConfigManager.system.getCompanyPath()).setImgSrc(ConfigManager.system.getCompanyLogoPath().isEmpty() ? Image.getInstance().getAppLogo() : ConfigManager.system.getCompanyLogoPath());
        this.appLogoPath = link.getString();
        if (this.notifyMessage == null && (sessionNotifyMessage = (String)this.requestContext.getSession().getAttribute("_notify")) != null) {
            this.requestContext.getSession().removeAttribute("_notify");
            if (this.requestContext.getParameterBoolean("_notify")) {
                this.notifyMessage = sessionNotifyMessage;
            }
        }
        NotificationBarTemplate notificationTemplate = this.addTemplate(new NotificationBarTemplate());
        if (this.notifyMessage != null) {
            notificationTemplate.setNotifyMessage(this.notifyMessage);
        }
    }

    @Override
    public String getJspPath() {
        return "/jsp/common/template/Header.jsp";
    }

    public void setTitleClassNoLine() {
        this.titleClass = "noLine";
    }

    public void addNavLink(Link link) {
        if (link != null) {
            this.navLinks.add(link);
        }
    }

    public void addHeaderCmds(Link headerCmd) {
        headerCmd.setStyleClass("btn");
        this.headerCmds.add(headerCmd);
    }

    public List<Link> getHeaderCmds() {
        return this.headerCmds;
    }

    public String getTitleClass() {
        return this.titleClass;
    }

    public Integer getModuleId() {
        return this.moduleId;
    }

    public String getModuleIds() {
        return StringUtils.join(ConfigManager.system.getModuleTabs(), ",");
    }

    public String getAppLogoPath() {
        return this.appLogoPath;
    }

    public String getNotificationMsg() {
        return this.notifyMessage;
    }

    public void setNotifyMessageKey(String notifyMessageKey) {
        this.notifyMessage = Localizer.getText(this.requestContext, notifyMessageKey);
    }

    public List<Map<String, String>> getModuleTabs() {
        return this.moduleTabs;
    }

    public String getSectionText() {
        return this.sectionText;
    }

    public void setSectionKey(String sectionKey) {
        this.sectionText = Localizer.getText(this.requestContext, sectionKey);
    }

    public void setSectionKey(String sectionKey, Object[] sectionMsgParams) {
        this.sectionText = Localizer.getText(this.requestContext, sectionKey, sectionMsgParams);
    }

    public void setSectionText(String sectionText) {
        this.sectionText = sectionText;
    }

    public String getNavCmds() {
        return this.navCmds;
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public String getOnloadJavascript() {
        return this.onloadJavascript;
    }

    public void setOnloadJavascript(String onloadJavascript) {
        this.onloadJavascript = onloadJavascript;
    }
}

