/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.common.template;

import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class RootTemplate
extends BaseTemplate {
    private static final Logger LOGGER = Logger.getLogger(RootTemplate.class.getName());
    private List<String> jspTemplates = new ArrayList<String>();
    protected String ajaxTemplatePath;
    protected String templatePath;
    protected String templateName = "success";
    private boolean ajax;
    private String prefix;

    public RootTemplate(RequestContext requestContext) {
        super(RootTemplate.class);
        this.setRequestContext(requestContext);
        this.ajax = requestContext.isAjax();
    }

    public String findTemplate(String templateName) throws Exception {
        this.applyTemplate();
        if (this.ajax) {
            this.ajaxTemplatePath = templateName.equals("standard_template") || templateName.equals("standard_autogen_template") ? RootTemplate.getTemplatePath(this.requestContext, templateName) : this.templatePath;
            templateName = "ajax_template";
        }
        LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.TEMPLATE_PREFIX), LogConfigManager.TEMPLATE_PREFIX + " Forwarding to JSP");
        return templateName;
    }

    private void applyTemplates(List<BaseTemplate> templates, boolean applySubTemplates) throws Exception {
        for (BaseTemplate template : templates) {
            template.applyTemplate();
            this.request.setAttribute(template.getName() + (template.getPrefix() == null ? "" : template.getPrefix()), (Object)template);
            if (applySubTemplates) {
                if (template.getJspPath() != null) {
                    String jspPath = template.getJspPath();
                    LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.TEMPLATE_PREFIX), LogConfigManager.TEMPLATE_PREFIX + " Include: " + jspPath);
                    this.jspTemplates.add(jspPath);
                } else {
                    LOGGER.log(LogConfigManager.getLogLevel(LogConfigManager.TEMPLATE_PREFIX), LogConfigManager.TEMPLATE_PREFIX + " Missing template jsp: " + template);
                }
            }
            this.applyTemplates(template.getTemplates(), false);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void applyTemplate() throws Exception {
        this.applyTemplates(this.getTemplates(), true);
        this.request.setAttribute("image", (Object)Image.getInstance());
        this.request.setAttribute("path", (Object)AppPaths.getInstance());
        this.request.setAttribute(RootTemplate.class.getSimpleName(), (Object)this);
        Long pageStartTime = (Long)this.request.getAttribute("_pageStartTime");
        if (pageStartTime != null && this.requestContext.getUser().isLoggedOn()) {
            this.request.setAttribute("_pageExecutionTime", (Object)Localizer.getText(this.requestContext, "common.pageExecutionTime", new Object[]{new DecimalFormat("#0.000").format((double)(System.currentTimeMillis() - pageStartTime) / 1000.0)}));
        }
        this.templatePath = RootTemplate.getTemplatePath(this.requestContext, this.templateName);
    }

    public static String getTemplatePath(RequestContext requestContext, String templateName) {
        Map resultsMap;
        ResultConfig resultConfig;
        String templatePath = null;
        ActionConfig actionConfig = requestContext.getActionConfig();
        if (actionConfig != null && (resultConfig = (ResultConfig)(resultsMap = actionConfig.getResults()).get(templateName)) != null) {
            templatePath = (String)resultConfig.getParams().get("location");
        }
        return templatePath;
    }

    public List<String> getJspTemplates() {
        return this.jspTemplates;
    }

    public void setAttribute(String key, Object value) {
        this.request.setAttribute(key, value);
    }

    public void setPathAttribute(String key, String value) {
        this.request.setAttribute(key, (Object)(AppPaths.ROOT + value));
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isAjax() {
        return this.ajax;
    }

    public String getAjaxTemplatePath() {
        return this.ajaxTemplatePath;
    }

    public void setAjaxTemplatePath(String ajaxTemplatePath) {
        this.ajaxTemplatePath = ajaxTemplatePath;
    }

    public String getDetailsTableStyle() {
        return ConfigManager.system.getDetailsTableStyle();
    }
}

