/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.common.template;

import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SortByIconLink;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableHeaderTemplate
extends BaseTemplate {
    private List<String> columnList;
    private List<String> sortableColumnList;
    private String columnPath;
    private String columnTextKey;
    private Object rowCmd;
    private String orderBy;
    private String order;
    private List<Map<String, String>> headerList;
    private String orderParamName = "order";
    private String orderByParamName = "orderBy";

    public TableHeaderTemplate(String prefix) {
        super(TableHeaderTemplate.class, prefix);
    }

    @Override
    public void init() {
    }

    @Override
    public void applyTemplate() {
        if (this.columnPath != null) {
            String columnPathSeparator = !this.columnPath.contains("?") ? "?" : "&";
            this.columnPath = this.columnPath + columnPathSeparator;
        }
        this.headerList = new ArrayList<Map<String, String>>();
        StringBuilder urlParams = new StringBuilder();
        SortByIconLink sortByUi = new SortByIconLink(this.order);
        sortByUi.setOrderParamName(this.orderParamName);
        urlParams.append(sortByUi.getUrl());
        if (this.rowCmd != null) {
            urlParams.append("&rowCmd=").append(this.rowCmd);
        }
        for (String column : this.columnList) {
            Link link = new Link(this.requestContext);
            link.setEscapeTitle(column.isEmpty() || column.equals("rownum") ? "&nbsp;" : Localizer.getText(this.requestContext, this.columnTextKey + column));
            if (this.sortableColumnList != null && this.sortableColumnList.contains(column)) {
                link.setInlineImage(sortByUi.getImg(this.orderBy, column));
                link.setAjaxPath(this.columnPath + this.orderByParamName + "=" + column + urlParams);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("key", column.isEmpty() ? "rownum" : column);
            map.put("name", link.getString());
            this.headerList.add(map);
        }
    }

    public void setColumnPath(String columnPath) {
        this.columnPath = columnPath;
    }

    public void setColumnList(List<String> columnList) {
        this.columnList = columnList;
    }

    public void setSortableColumnList(List<String> sortableColumnList) {
        this.sortableColumnList = sortableColumnList;
    }

    public void setColumnTextKey(String columnTextKey) {
        this.columnTextKey = columnTextKey;
    }

    public void setRowCmd(Object rowCmd) {
        this.rowCmd = rowCmd;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public List<Map<String, String>> getHeaderList() {
        return this.headerList;
    }

    public String getOrderParamName() {
        return this.orderParamName;
    }

    public void setOrderParamName(String orderParamName) {
        this.orderParamName = orderParamName;
    }

    public String getOrderByParamName() {
        return this.orderByParamName;
    }

    public void setOrderByParamName(String orderByParamName) {
        this.orderByParamName = orderByParamName;
    }
}

