/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.common.template;

import com.kwoksys.action.common.template.TableEmptyTemplate;
import com.kwoksys.action.common.template.TableHeaderTemplate;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.properties.Localizer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableTemplate
extends BaseTemplate {
    public static final String STYLE_TAB = "tabBody";
    public static final String STYLE_LIST = "standard listTable stripedList";
    private List<String> columnHeaders;
    private List<String> sortableColumnHeaders;
    private String columnPath;
    private String columnTextKey;
    private String rowCmd;
    private String orderBy;
    private String order;
    private String orderByParamName;
    private String orderParamName;
    private int colSpan;
    private boolean canRemoveItem;
    private String formRemoveItemAction;
    private boolean formSelectMultipleRows;
    private Map<String, String> formHiddenVariableMap = new LinkedHashMap<String, String>();
    private Map<String, String> formButtons = new LinkedHashMap<String, String>();
    private String formRowIdName;
    private String formName = "form";
    private String style = "standard listTable stripedList";
    private List<DataRow> dataList = new ArrayList<DataRow>();
    private String emptyRowMsgKey = "";
    private TableHeaderTemplate tableHeader;
    private TableEmptyTemplate tableEmptyTemplate;

    public TableTemplate() {
        this((String)null);
    }

    public TableTemplate(String prefix) {
        super(TableTemplate.class, prefix);
    }

    @Override
    public void init() {
        this.tableHeader = this.addTemplate(new TableHeaderTemplate(this.prefix));
        this.tableEmptyTemplate = this.addTemplate(new TableEmptyTemplate(this.prefix));
    }

    @Override
    public void applyTemplate() throws Exception {
        if (this.requestContext.getUser() != null && this.formRemoveItemAction != null) {
            this.canRemoveItem = this.requestContext.getUser().hasPermission(this.formRemoveItemAction);
        }
        if (this.canRemoveItem) {
            this.columnHeaders = new ArrayList<String>(this.columnHeaders);
            this.columnHeaders.add(0, "");
            if (this.formButtons.isEmpty()) {
                this.formButtons.put("form.button.remove", "common.form.confirmRemove");
            }
        }
        this.tableHeader.setColumnList(this.columnHeaders);
        this.tableHeader.setSortableColumnList(this.sortableColumnHeaders);
        this.tableHeader.setColumnPath(this.columnPath);
        this.tableHeader.setColumnTextKey(this.columnTextKey);
        this.tableHeader.setRowCmd(this.rowCmd);
        this.tableHeader.setOrderBy(this.orderBy);
        this.tableHeader.setOrder(this.order);
        if (this.orderByParamName != null) {
            this.tableHeader.setOrderByParamName(this.orderByParamName);
        }
        if (this.orderParamName != null) {
            this.tableHeader.setOrderParamName(this.orderParamName);
        }
        this.colSpan = this.columnHeaders.size();
        if (this.dataList == null || this.dataList.isEmpty()) {
            this.tableEmptyTemplate.setColSpan(this.columnHeaders.size());
            if (!this.emptyRowMsgKey.isEmpty()) {
                this.tableEmptyTemplate.setRowText(Localizer.getText(this.requestContext, this.emptyRowMsgKey));
            }
        }
    }

    public void addRow(List<String> columns) {
        DataRow dataRow = new DataRow();
        dataRow.setColumns(columns);
        this.dataList.add(dataRow);
    }

    @Override
    public String getJspPath() {
        return "/jsp/common/template/Table.jsp";
    }

    public void setColumnPath(String columnPath) {
        this.columnPath = columnPath;
    }

    public void setColumnHeaders(List<String> columnHeaders) {
        this.columnHeaders = columnHeaders;
    }

    public void setSortableColumnHeaders(List<String> sortableColumnHeaders) {
        this.sortableColumnHeaders = sortableColumnHeaders;
    }

    public void setColumnTextKey(String columnTextKey) {
        this.columnTextKey = columnTextKey;
    }

    public void setRowCmd(String rowCmd) {
        this.rowCmd = rowCmd;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public void setDataList(List<DataRow> dataList) {
        this.dataList = dataList;
    }

    public List<DataRow> getDataList() {
        return this.dataList;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getOrderByParamName() {
        return this.orderByParamName;
    }

    public void setOrderByParamName(String orderByParamName) {
        this.orderByParamName = orderByParamName;
    }

    public String getOrderParamName() {
        return this.orderParamName;
    }

    public void setOrderParamName(String orderParamName) {
        this.orderParamName = orderParamName;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public String getFormRemoveItemAction() {
        return this.formRemoveItemAction;
    }

    public void setFormRemoveItemAction(String formRemoveItemAction) {
        this.formRemoveItemAction = formRemoveItemAction;
    }

    public boolean isCanRemoveItem() {
        return this.canRemoveItem;
    }

    public String getFormRowIdName() {
        return this.formRowIdName;
    }

    public void setFormRowIdName(String formRowIdName) {
        this.formRowIdName = formRowIdName;
    }

    public Map<String, String> getFormButtons() {
        return this.formButtons;
    }

    public Map<String, String> getFormHiddenVariableMap() {
        return this.formHiddenVariableMap;
    }

    public void setFormHiddenVariableMap(Map<String, String> formHiddenVariableMap) {
        this.formHiddenVariableMap = formHiddenVariableMap;
    }

    public void setEmptyRowMsgKey(String emptyRowMsgKey) {
        this.emptyRowMsgKey = emptyRowMsgKey;
    }

    public void setFormSelectMultipleRows(boolean formSelectMultipleRows) {
        this.formSelectMultipleRows = formSelectMultipleRows;
    }

    public boolean isFormSelectMultipleRows() {
        return this.formSelectMultipleRows;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }
}

