/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.contacts.CompanyForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import java.util.Map;

public class CompanyAddAction
extends Action2 {
    public String add() throws Exception {
        Company company = new Company();
        CompanyForm actionForm = this.getBaseForm(CompanyForm.class);
        actionForm.setId("companyAddForm");
        if (!actionForm.isResubmit()) {
            company.setTypeIds(CompanyUtils.DEFAULT_COMPANY_TYPES);
            actionForm.setCompany(company);
        }
        company.loadAttrs(this.requestContext);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.CONTACTS_COMPANY_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.CONTACTS_COMPANY_LIST).getString());
        standardTemplate.setAttribute("companyTypes", new AttributeManager(this.requestContext).getActiveAttrFieldOptionsCache(Attributes.COMPANY_TYPES));
        standardTemplate.setAttribute("company", company);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("contactMgmt.cmd.companyAdd");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        errorsTemplate.setMessageKey("contactMgmt.companyAdd.sectionHeader");
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.COMPANY);
        customFieldsTemplate.setForm(actionForm);
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        CompanyForm actionForm = this.saveActionForm(new CompanyForm());
        Company company = new Company();
        company.setName(actionForm.getCompanyName());
        company.setDescription(actionForm.getCompanyDescription());
        company.setTags(actionForm.getCompanyTags());
        company.setTypeIds(actionForm.getCompanyTypes());
        Map<Integer, Attribute> customAttributes = new AttributeManager(this.requestContext).populateCustomFieldValues(actionForm, company);
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        ActionMessages errors = contactService.addCompany(company, customAttributes);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_ADD + "?" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_DETAIL + "?companyId=" + company.getId());
    }
}

