/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableEmptyTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.contacts.CompanyBookmarkForm;
import com.kwoksys.action.contacts.CompanySpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.contacts.dto.CompanyBookmark;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.dao.BookmarkQueries;
import com.kwoksys.biz.system.dto.Bookmark;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CompanyBookmarkAction
extends Action2 {
    public String index() throws Exception {
        Link link;
        AccessUser user = this.requestContext.getUser();
        int bookmarkRowSpan = 2;
        CompanyBookmarkForm actionForm = this.getBaseForm(CompanyBookmarkForm.class);
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Company company = contactService.getCompany(actionForm.getCompanyId());
        boolean canDeleteBookmark = Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_BOOKMARK_DELETE_2);
        String deleteBookmarkPath = AppPaths.CONTACTS_COMPANY_BOOKMARK_DELETE_2;
        if (canDeleteBookmark) {
            ++bookmarkRowSpan;
        }
        boolean canEditBookmark = Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_BOOKMARK_EDIT);
        String editBookmarkPath = AppPaths.CONTACTS_COMPANY_BOOKMARK_EDIT;
        if (canEditBookmark) {
            ++bookmarkRowSpan;
        }
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(BookmarkQueries.getOrderByColumn("bookmark_name"));
        List<Bookmark> bookmarks = contactService.getCompanyBookmarks(queryCriteria, company.getId());
        ArrayList bookmarkList = new ArrayList();
        if (!bookmarks.isEmpty()) {
            for (Bookmark bookmark : bookmarks) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("bookmarkPath", new Link(this.requestContext).setExternalPath(bookmark.getPath()).setTitle(bookmark.getName()).setInlineImage(Image.getInstance().getExternalPopupIcon(this.requestContext)).setImgAlignRight().getString());
                if (canEditBookmark) {
                    map.put("bookmarkEditPath", new Link(this.requestContext).setAjaxPath(editBookmarkPath + "?companyId=" + company.getId() + "&bookmarkId=" + bookmark.getId()).setTitleKey("common.action.Edit").getString());
                }
                map.put("bookmarkId", String.valueOf(bookmark.getId()));
                bookmarkList.add(map);
            }
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("companyId", company.getId());
        standardTemplate.setAttribute("canDeleteBookmark", canDeleteBookmark);
        standardTemplate.setPathAttribute("deleteBookmarkPath", deleteBookmarkPath);
        standardTemplate.setAttribute("canEditBookmark", canEditBookmark);
        standardTemplate.setAttribute("bookmarkRowSpan", bookmarkRowSpan);
        standardTemplate.setAttribute("bookmarkList", bookmarkList);
        if (bookmarks.isEmpty()) {
            TableEmptyTemplate empty = standardTemplate.addTemplate(new TableEmptyTemplate());
            empty.setColSpan(bookmarkRowSpan);
            empty.setRowText(Localizer.getText(this.requestContext, "contactMgmt.companyBookmark_emptyTableMessage"));
        }
        standardTemplate.addTemplate(new CompanySpecTemplate(company));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("contactMgmt.companyDetail.header", new Object[]{company.getName()});
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_BOOKMARK_ADD)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_COMPANY_BOOKMARK_ADD + "?companyId=" + company.getId());
            link.setTitleKey("bookmarkMgmt.bookmarkAdd");
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_COMPANY_LIST);
            link.setTitleKey("contactMgmt.cmd.companyList");
            header.addHeaderCmds(link);
        }
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(CompanyUtils.getCompanyTabs(this.requestContext, company));
        tabs.setTabActive("bookmarkTab");
        return standardTemplate.findTemplate("standard_template");
    }

    public String add() throws Exception {
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        CompanyBookmarkForm actionForm = this.getBaseForm(CompanyBookmarkForm.class);
        Company company = contactService.getCompany(actionForm.getCompanyId());
        Bookmark bookmark = new Bookmark();
        if (!actionForm.isResubmit()) {
            actionForm.setBookmark(bookmark);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("companyId", company.getId());
        standardTemplate.setPathAttribute("formAction", AppPaths.CONTACTS_COMPANY_BOOKMARK_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.CONTACTS_COMPANY_BOOKMARK + "?companyId=" + company.getId()).getString());
        standardTemplate.addTemplate(new CompanySpecTemplate(company));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("contactMgmt.companyDetail.header", new Object[]{company.getName()});
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        CompanyBookmarkForm actionForm = this.saveActionForm(new CompanyBookmarkForm());
        Integer companyId = actionForm.getCompanyId();
        contactService.getCompany(companyId);
        CompanyBookmark bookmark = new CompanyBookmark(companyId);
        bookmark.setName(actionForm.getBookmarkName());
        bookmark.setPath(actionForm.getBookmarkPath());
        bookmark.setDescription("");
        ActionMessages errors = contactService.addCompanyBookmark(bookmark);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_BOOKMARK_ADD + "?companyId=" + companyId + "&" + "_error=true");
        }
        contactService.resetCompanyBookmarkCount(companyId);
        return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_BOOKMARK + "?companyId=" + companyId);
    }

    public String delete2() throws Exception {
        Integer companyId = this.requestContext.getParameter("companyId");
        Integer bookmarkId = this.requestContext.getParameter("bookmarkId");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        contactService.getCompany(companyId);
        Bookmark bookmark = contactService.getCompanyBookmark(companyId, bookmarkId);
        contactService.deleteCompanyBookmark(bookmark);
        contactService.resetCompanyBookmarkCount(companyId);
        return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_BOOKMARK + "?companyId=" + companyId);
    }

    public String edit() throws Exception {
        CompanyBookmarkForm actionForm = this.getBaseForm(CompanyBookmarkForm.class);
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Integer companyId = actionForm.getCompanyId();
        Company company = contactService.getCompany(companyId);
        Integer bookmarkId = actionForm.getBookmarkId();
        Bookmark bookmark = contactService.getCompanyBookmark(companyId, bookmarkId);
        if (!actionForm.isResubmit()) {
            actionForm.setBookmark(bookmark);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("companyId", companyId);
        standardTemplate.setPathAttribute("formAction", AppPaths.CONTACTS_COMPANY_BOOKMARK_EDIT_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.CONTACTS_COMPANY_BOOKMARK + "?companyId=" + companyId).getString());
        standardTemplate.setAttribute("bookmarkId", bookmarkId);
        standardTemplate.addTemplate(new CompanySpecTemplate(company));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("contactMgmt.companyDetail.header", new Object[]{company.getName()});
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        CompanyBookmarkForm actionForm = this.saveActionForm(new CompanyBookmarkForm());
        Integer companyId = actionForm.getCompanyId();
        contactService.getCompany(companyId);
        Bookmark bookmark = contactService.getCompanyBookmark(companyId, actionForm.getBookmarkId());
        bookmark.setName(actionForm.getBookmarkName());
        bookmark.setPath(actionForm.getBookmarkPath());
        bookmark.setDescription("");
        ActionMessages errors = contactService.updateCompanyBookmark(bookmark);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_BOOKMARK_EDIT + "?companyId=" + companyId + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_BOOKMARK + "?companyId=" + companyId);
    }
}

