/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.contacts.CompanySpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contacts.core.ContactUtils;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.List;

public class CompanyContactAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        AccessUser user = this.requestContext.getUser();
        Integer companyId = this.requestContext.getParameter("companyId");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "COMPANY_CONTACTS_ORDER_BY", "contact_first_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "COMPANY_CONTACTS_ORDER", "asc");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Company company = contactService.getCompany(companyId);
        QueryCriteria queryCriteria = new QueryCriteria();
        if (ContactUtils.isSortableColumn(orderBy)) {
            queryCriteria.addSortColumn(ContactQueries.getOrderByColumn(orderBy), order);
        }
        List<String> columnHeaders = ContactUtils.getEmployeeContactColumnHeader();
        List<Contact> contacts = contactService.getCompanyContacts(queryCriteria, company.getId(), ObjectTypes.COMPANY_EMPLOYEE_CONTACT);
        List<DataRow> dataList = ContactUtils.formatContacts(this.requestContext, contacts, columnHeaders, new Counter());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("companyId", companyId);
        standardTemplate.addTemplate(new CompanySpecTemplate(company));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("contactMgmt.companyDetail.header", new Object[]{company.getName()});
        if (Access.hasPermission(user, AppPaths.CONTACTS_CONTACT_ADD)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_CONTACT_ADD + "?companyId=" + companyId);
            link.setTitleKey("contactMgmt.cmd.employeeContactAdd");
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_CONTACT_EXPORT)) {
            link = new Link(this.requestContext);
            link.setExportPath(AppPaths.CONTACTS_COMPANY_CONTACT_EXPORT + "?companyId=" + companyId);
            link.setTitleKey("contactMgmt.cmd.companyOtherContactsExport");
            link.setInlineImage(Image.getInstance().getFileCsvIcon());
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_COMPANY_LIST);
            link.setTitleKey("contactMgmt.cmd.companyList");
            header.addHeaderCmds(link);
        }
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(CompanyUtils.getCompanyTabs(this.requestContext, company));
        tabs.setTabActive("otherContactTab");
        TableTemplate tableHeader = standardTemplate.addTemplate(new TableTemplate());
        tableHeader.setDataList(dataList);
        tableHeader.setColumnHeaders(columnHeaders);
        tableHeader.setSortableColumnHeaders(ContactUtils.getSortableContactColumnList());
        tableHeader.setColumnPath(AppPaths.CONTACTS_COMPANY_CONTACT + "?companyId=" + companyId);
        tableHeader.setColumnTextKey("common.column.");
        tableHeader.setOrderBy(orderBy);
        tableHeader.setOrder(order);
        tableHeader.setEmptyRowMsgKey("contactMgmt.companyContact.emptyTableMessage");
        return standardTemplate.findTemplate("standard_autogen_template");
    }
}

