/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.reports.writers.CsvReportWriter;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import java.util.ArrayList;
import java.util.List;

public class CompanyContactExportAction
extends Action2 {
    public String execute() throws Exception {
        Integer companyId = this.requestContext.getParameter("companyId");
        String orderBy = SessionManager.getAttribute(this.request, "COMPANY_CONTACTS_ORDER_BY", "contact_first_name");
        String order = SessionManager.getAttribute(this.request, "COMPANY_CONTACTS_ORDER", "asc");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Company company = contactService.getCompany(companyId);
        String[] columnKeys = new String[]{"contact_first_name", "contact_last_name", "contact_title", "contact_email_primary", "contact_phone_work", "company_name"};
        ResponseContext responseContext = new ResponseContext(this.response);
        responseContext.setAttachementName(Localizer.getText(this.requestContext, "contactMgmt.companyContactExport.filename", new Object[]{company.getName()}));
        CsvReportWriter csvReportWriter = new CsvReportWriter();
        csvReportWriter.init(responseContext);
        ArrayList<String> columnHeaders = new ArrayList<String>();
        for (String column : columnKeys) {
            columnHeaders.add(Localizer.getText(this.requestContext, "common.column." + column));
        }
        csvReportWriter.addHeaderRow(columnHeaders);
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(ContactQueries.getOrderByColumn(orderBy), order);
        List<Contact> contacts = contactService.getCompanyContacts(queryCriteria, company.getId(), ObjectTypes.COMPANY_EMPLOYEE_CONTACT);
        for (Contact contact : contacts) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : columnKeys) {
                if (column.equals("contact_first_name")) {
                    columns.add(contact.getFirstName());
                    continue;
                }
                if (column.equals("contact_last_name")) {
                    columns.add(contact.getLastName());
                    continue;
                }
                if (column.equals("contact_title")) {
                    columns.add(contact.getTitle());
                    continue;
                }
                if (column.equals("contact_email_primary")) {
                    columns.add(contact.getEmailPrimary());
                    continue;
                }
                if (column.equals("contact_phone_work")) {
                    columns.add(contact.getPhoneWork());
                    continue;
                }
                if (!column.equals("company_name")) continue;
                columns.add(contact.getCompanyName());
            }
            csvReportWriter.addRow(columns);
        }
        return csvReportWriter.close();
    }
}

