/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.DetailTableTemplate;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.util.HtmlUtils;

public class CompanyContactSpecTemplate
extends BaseTemplate {
    private Contact contact;
    private DetailTableTemplate detailTableTemplate = new DetailTableTemplate();

    public CompanyContactSpecTemplate(Contact contact) {
        super(CompanyContactSpecTemplate.class);
        this.contact = contact;
    }

    @Override
    public void init() {
        this.addTemplate(this.detailTableTemplate);
    }

    @Override
    public void applyTemplate() throws Exception {
        this.detailTableTemplate.setNumColumns(2);
        DetailTableTemplate.Td td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_main_label");
        td.setValue(HtmlUtils.encode(this.contact.getTitle()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.company_name");
        td.setValue(Links.getCompanyDetailsLink(this.requestContext, this.contact.getCompanyName(), this.contact.getCompanyId()).getString());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_main_phone");
        td.setValue(HtmlUtils.encode(this.contact.getPhoneWork()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_fax");
        td.setValue(HtmlUtils.encode(this.contact.getFax()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_main_email");
        td.setValue(HtmlUtils.formatMailtoLink(this.contact.getEmailPrimary()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_main_website");
        td.setValue(HtmlUtils.formatExternalLink(this.requestContext, this.contact.getHomepageUrl()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_address_street_primary");
        td.setValue(HtmlUtils.encode(this.contact.getAddressStreetPrimary()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_address_city_primary");
        td.setValue(HtmlUtils.encode(this.contact.getAddressCityPrimary()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_address_state_primary");
        td.setValue(HtmlUtils.encode(this.contact.getAddressStatePrimary()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_address_zipcode_primary");
        td.setValue(HtmlUtils.encode(this.contact.getAddressZipcodePrimary()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_address_country_primary");
        td.setValue(HtmlUtils.encode(this.contact.getAddressCountryPrimary()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_description");
        td.setValue(HtmlUtils.formatMultiLineDisplay(this.contact.getDescription()));
    }

    @Override
    public String getJspPath() {
        return "/jsp/contacts/CompanyContactSpecTemplate.jsp";
    }
}

