/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.contacts.CompanySpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.contracts.core.ContractSearch;
import com.kwoksys.biz.contracts.core.ContractUtils;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.List;

public class CompanyContractsAction
extends Action2 {
    public String execute() throws Exception {
        Integer companyId = this.requestContext.getParameter("companyId");
        AccessUser user = this.requestContext.getUser();
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Company company = contactService.getCompany(companyId);
        List<String> columnHeaders = ContractUtils.getColumnHeaderList();
        ContractSearch contractSearch = new ContractSearch();
        contractSearch.put("contractProviderId", company.getId());
        QueryCriteria queryCriteria = new QueryCriteria(contractSearch);
        queryCriteria.addSortColumn(ContactQueries.getOrderByColumn("contract_name"));
        List<DataRow> dataList = ContractUtils.fetchContractList(this.requestContext, queryCriteria, new Counter());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("contactMgmt.companyDetail.header", new Object[]{company.getName()});
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_LIST)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_COMPANY_LIST);
            link.setTitleKey("contactMgmt.cmd.companyList");
            header.addHeaderCmds(link);
        }
        standardTemplate.addTemplate(new CompanySpecTemplate(company));
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(CompanyUtils.getCompanyTabs(this.requestContext, company));
        tabs.setTabActive("contractsTab");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setDataList(dataList);
        tableTemplate.setEmptyRowMsgKey("contracts.contractList.emptyTableMessage");
        return standardTemplate.findTemplate("standard_autogen_template");
    }
}

