/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableEmptyTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.contacts.CompanySpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CompanyDetailAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        Integer companyId = this.requestContext.getParameter("companyId");
        AccessUser user = this.requestContext.getUser();
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Company company = contactService.getCompany(companyId);
        boolean canEditContact = user.hasPermission(AppPaths.CONTACTS_COMPANY_CONTACT_EDIT);
        boolean canDeleteContact = user.hasPermission(AppPaths.CONTACTS_COMPANY_CONTACT_DELETE);
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(ContactQueries.getOrderByColumn("contact_title"));
        List<Contact> contacts = contactService.getCompanyContacts(queryCriteria, companyId, ObjectTypes.COMPANY_MAIN_CONTACT);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("companyId", companyId);
        if (!contacts.isEmpty()) {
            ArrayList mainContactList = new ArrayList();
            for (Contact contact : contacts) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("contact", contact);
                map.put("contactNote", HtmlUtils.formatMultiLineDisplay(contact.getDescription()));
                if (!contact.getPhoneWork().isEmpty()) {
                    map.put("contactPhoneWork", Image.getInstance().getContactPhone(this.requestContext) + HtmlUtils.encode(contact.getPhoneWork()));
                }
                map.put("contactFax", HtmlUtils.encode(contact.getFax()));
                if (!contact.getEmailPrimary().isEmpty()) {
                    map.put("contactEmailPrimary", Image.getInstance().getContactEmail(this.requestContext) + HtmlUtils.formatMailtoLink(contact.getEmailPrimary()));
                }
                map.put("contactHomepageUrl", HtmlUtils.formatExternalLink(this.requestContext, contact.getHomepageUrl()));
                if (canEditContact || canDeleteContact) {
                    StringBuilder contactCommands = new StringBuilder();
                    if (canEditContact) {
                        contactCommands.append(new Link(this.requestContext).setAjaxPath(AppPaths.CONTACTS_COMPANY_CONTACT_EDIT + "?contactId=" + contact.getId()).setInlineImage(Image.getInstance().getActionEdit(this.requestContext, "common.action.Edit")).getString());
                        if (canDeleteContact) {
                            contactCommands.append(" | ");
                        }
                    }
                    if (canDeleteContact) {
                        contactCommands.append(new Link(this.requestContext).setAjaxPath(AppPaths.CONTACTS_COMPANY_CONTACT_DELETE + "?contactId=" + contact.getId()).setInlineImage(Image.getInstance().getActionDelete(this.requestContext, "common.action.Delete")).getString());
                    }
                    map.put("contactCommands", contactCommands.toString());
                }
                mainContactList.add(map);
            }
            standardTemplate.setAttribute("mainContactList", mainContactList);
        } else {
            TableEmptyTemplate empty = standardTemplate.addTemplate(new TableEmptyTemplate());
            empty.setRowText(Localizer.getText(this.requestContext, "contactMgmt.companyDetail.emptyTableMessage"));
        }
        CompanySpecTemplate tmpl = standardTemplate.addTemplate(new CompanySpecTemplate(company));
        tmpl.setPopulateCompanyTagList(true);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("contactMgmt.companyDetail.header", new Object[]{company.getName()});
        if (user.hasPermission(AppPaths.CONTACTS_COMPANY_EDIT)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_COMPANY_EDIT + "?companyId=" + companyId);
            link.setTitleKey("contactMgmt.companyEdit.title");
            header.addHeaderCmds(link);
        }
        if (user.hasPermission(AppPaths.CONTACTS_COMPANY_DELETE)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_COMPANY_DELETE + "?companyId=" + companyId);
            link.setTitleKey("contactMgmt.companyDelete.title");
            header.addHeaderCmds(link);
        }
        if (user.hasPermission(AppPaths.CONTACTS_COMPANY_CONTACT_ADD)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_COMPANY_CONTACT_ADD + "?companyId=" + companyId);
            link.setTitleKey("contactMgmt.cmd.companyContactAdd");
            header.addHeaderCmds(link);
        }
        if (user.hasPermission(AppPaths.CONTACTS_COMPANY_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_COMPANY_LIST);
            link.setTitleKey("contactMgmt.cmd.companyList");
            header.addHeaderCmds(link);
        }
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(CompanyUtils.getCompanyTabs(this.requestContext, company));
        tabs.setTabActive("mainContactTab");
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.COMPANY);
        customFieldsTemplate.setObjectId(companyId);
        customFieldsTemplate.setShowDefaultHeader(false);
        return standardTemplate.findTemplate("standard_template");
    }
}

