/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.contacts.CompanyForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.StringUtils;
import java.util.List;
import java.util.Map;

public class CompanyEditAction
extends Action2 {
    public String edit() throws Exception {
        CompanyForm actionForm = this.getBaseForm(CompanyForm.class);
        actionForm.setId("companyEditForm");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Integer companyId = actionForm.getCompanyId();
        Company company = contactService.getCompany(companyId);
        company.loadAttrs(this.requestContext);
        if (!actionForm.isResubmit()) {
            company.setTypeIds(contactService.getCompanyTypes(company.getId()));
            QueryCriteria queryCriteria = new QueryCriteria();
            queryCriteria.addSortColumn(ContactQueries.getOrderByColumn("tag_name"));
            company.setTags(StringUtils.join(contactService.getCompanyTags(queryCriteria, companyId), "tag_name", ", "));
            actionForm.setCompany(company);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.CONTACTS_COMPANY_EDIT_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.CONTACTS_COMPANY_DETAIL + "?companyId=" + companyId).getString());
        List<Integer> companyTypeIds = ServiceProvider.getContactService(this.requestContext).getCompanyTypes(company.getId());
        standardTemplate.setAttribute("companyTypes", new AttributeManager(this.requestContext).setSelectedAttrFieldIds(companyTypeIds).getActiveAttrFieldOptionsCache(Attributes.COMPANY_TYPES));
        standardTemplate.setAttribute("company", company);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("contactMgmt.companyEdit.title");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        errorsTemplate.setMessageKey("contactMgmt.companyEdit.sectionHeader");
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.COMPANY);
        customFieldsTemplate.setObjectId(companyId);
        customFieldsTemplate.setForm(actionForm);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        CompanyForm actionForm = this.saveActionForm(new CompanyForm());
        Company company = new Company();
        company.setId(actionForm.getCompanyId());
        company.setName(actionForm.getCompanyName());
        company.setDescription(actionForm.getCompanyDescription());
        company.setTags(actionForm.getCompanyTags());
        company.setTypeIds(actionForm.getCompanyTypes());
        Map<Integer, Attribute> customAttributes = new AttributeManager(this.requestContext).populateCustomFieldValues(actionForm, company);
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        ActionMessages errors = contactService.updateCompany(company, customAttributes);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_EDIT + "?companyId=" + company.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_DETAIL + "?companyId=" + company.getId());
    }
}

