/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.contacts.CompanySpecTemplate;
import com.kwoksys.action.files.FileAddTemplate;
import com.kwoksys.action.files.FileDeleteTemplate;
import com.kwoksys.action.files.FileEditTemplate;
import com.kwoksys.action.files.FileUploadForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.contacts.dto.CompanyFile;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.core.FileUtils;
import com.kwoksys.biz.files.dao.FileQueries;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class CompanyFileAction
extends Action2 {
    public String list() throws Exception {
        Link link;
        AccessUser user = this.requestContext.getUser();
        Integer companyId = this.requestContext.getParameter("companyId");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "FILES_ORDER_BY", "file_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "FILES_ORDER", "asc");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Company company = contactService.getCompany(companyId);
        boolean canDeleteFile = user.hasPermission(AppPaths.CONTACTS_COMPANY_FILE_DELETE);
        String fileDeletePath = AppPaths.CONTACTS_COMPANY_FILE_DELETE + "?companyId=" + companyId + "&fileId=";
        String fileEditPath = AppPaths.CONTACTS_COMPANY_FILE_EDIT + "?companyId=" + companyId + "&fileId=";
        boolean canDownloadFile = user.hasPermission(AppPaths.CONTACTS_COMPANY_FILE_DOWNLOAD);
        String fileDownloadPath = AppPaths.CONTACTS_COMPANY_FILE_DOWNLOAD + "?companyId=" + companyId + "&fileId=";
        QueryCriteria queryCriteria = new QueryCriteria();
        if (FileUtils.isSortableColumn(orderBy)) {
            queryCriteria.addSortColumn(FileQueries.getOrderByColumn(orderBy), order);
        }
        List<File> files = contactService.getCompanyFiles(queryCriteria, company.getId());
        ArrayList<String> columnHeaders = new ArrayList<String>(FileUtils.getFileColumnHeaders());
        if (canDeleteFile) {
            columnHeaders.add("command");
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.addTemplate(new CompanySpecTemplate(company));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("contactMgmt.companyDetail.header", new Object[]{company.getName()});
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        if (user.hasPermission(AppPaths.CONTACTS_COMPANY_FILE_ADD)) {
            link = new Link(this.requestContext);
            link.setTitleKey("files.fileAttach");
            if (fileService.isDirectoryExist(ConfigManager.file.getCompanyFileRepositoryLocation())) {
                link.setAjaxPath(AppPaths.CONTACTS_COMPANY_FILE_ADD + "?companyId=" + companyId);
                link.setInlineImage(Image.getInstance().getFileAddIcon());
            } else {
                link.setInlineImage(Image.getInstance().getWarning(Localizer.getText(this.requestContext, "files.warning.invalidPath")));
            }
            header.addHeaderCmds(link);
        }
        if (user.hasPermission(AppPaths.CONTACTS_COMPANY_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_COMPANY_LIST);
            link.setTitleKey("contactMgmt.cmd.companyList");
            header.addHeaderCmds(link);
        }
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(CompanyUtils.getCompanyTabs(this.requestContext, company));
        tabs.setTabActive("fileTab");
        TableTemplate tableHeader = standardTemplate.addTemplate(new TableTemplate());
        tableHeader.setColumnPath(AppPaths.CONTACTS_COMPANY_FILES + "?companyId=" + companyId);
        tableHeader.setColumnHeaders(columnHeaders);
        tableHeader.setColumnTextKey("files.colName.");
        tableHeader.setSortableColumnHeaders(FileUtils.getSortableColumns());
        tableHeader.setOrderBy(orderBy);
        tableHeader.setOrder(order);
        tableHeader.setEmptyRowMsgKey("files.noAttachments");
        if (!files.isEmpty()) {
            Counter counter = new Counter();
            for (File file : files) {
                ArrayList<String> columns = new ArrayList<String>();
                columns.add(counter.incr() + ".");
                columns.add(Links.getFileIconLink(this.requestContext, canDownloadFile, file.getLogicalName(), fileDownloadPath + file.getId()).getString());
                columns.add(HtmlUtils.encode(file.getTitle()));
                columns.add(file.getCreationDate());
                columns.add(FileUtils.formatFileSize(this.requestContext, file.getSize()));
                if (canDeleteFile) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(new Link(this.requestContext).setAjaxPath(fileEditPath + file.getId()).setTitleKey("common.action.Edit").getString());
                    sb.append(" | ");
                    sb.append(new Link(this.requestContext).setAjaxPath(fileDeletePath + file.getId()).setTitleKey("common.action.Delete").getString());
                    columns.add(sb.toString());
                }
                tableHeader.addRow(columns);
            }
        }
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add() throws Exception {
        Integer companyId = this.requestContext.getParameter("companyId");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Company company = contactService.getCompany(companyId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.addTemplate(new CompanySpecTemplate(company));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("files.fileAdd");
        FileAddTemplate fileAdd = standardTemplate.addTemplate(new FileAddTemplate(this.getBaseForm(FileUploadForm.class)));
        fileAdd.setFileName(this.requestContext.getParameterString("fileName0"));
        fileAdd.setFormAction(AppPaths.CONTACTS_COMPANY_FILE_ADD_2 + "?companyId=" + companyId);
        fileAdd.setFormCancelAction(AppPaths.CONTACTS_COMPANY_FILES + "?companyId=" + companyId);
        fileAdd.getErrorsTemplate().setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add2() throws Exception {
        Integer companyId = this.requestContext.getParameter("companyId");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        contactService.getCompany(companyId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        CompanyFile file = new CompanyFile(companyId);
        FileUploadForm actionForm = this.saveActionForm(new FileUploadForm());
        ActionMessages errors = fileService.addFile(file, actionForm);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.redirect(AppPaths.CONTACTS_COMPANY_FILE_ADD + "?companyId=" + companyId + "&" + "_error=true");
        }
        contactService.resetCompanyFileCount(companyId);
        return this.redirect(AppPaths.CONTACTS_COMPANY_FILES + "?companyId=" + companyId);
    }

    public String delete() throws Exception {
        Integer companyId = this.requestContext.getParameter("companyId");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Company company = contactService.getCompany(companyId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = contactService.getCompanyFile(companyId, fileId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("companyId", companyId);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("contactMgmt.companyDetail.header", new Object[]{company.getName()});
        standardTemplate.addTemplate(new CompanySpecTemplate(company));
        FileDeleteTemplate fileDelete = standardTemplate.addTemplate(new FileDeleteTemplate());
        fileDelete.setFile(file);
        fileDelete.setFormAction(AppPaths.CONTACTS_COMPANY_FILE_DELETE_2 + "?companyId=" + companyId + "&fileId=" + file.getId());
        fileDelete.setFormCancelAction(AppPaths.CONTACTS_COMPANY_FILES + "?companyId=" + companyId);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String delete2() throws Exception {
        Integer companyId = this.requestContext.getParameter("companyId");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        contactService.getCompany(companyId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = contactService.getCompanyFile(companyId, fileId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        fileService.deleteFile(file);
        contactService.resetCompanyFileCount(companyId);
        return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_FILES + "?companyId=" + companyId);
    }

    public String download() throws Exception {
        ResponseContext responseContext = new ResponseContext(this.response);
        Integer companyId = this.requestContext.getParameter("companyId");
        try {
            ContactService contactService = ServiceProvider.getContactService(this.requestContext);
            contactService.getCompany(companyId);
            Integer fileId = this.requestContext.getParameter("fileId");
            File file = contactService.getCompanyFile(companyId, fileId);
            FileService fileService = ServiceProvider.getFileService(this.requestContext);
            fileService.download(responseContext, file);
        }
        catch (ObjectNotFoundException e) {
            throw new FileNotFoundException();
        }
        return null;
    }

    public String edit() throws Exception {
        Integer companyId = this.requestContext.getParameter("companyId");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Company company = contactService.getCompany(companyId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = contactService.getCompanyFile(companyId, fileId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("companyId", companyId);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("contactMgmt.companyDetail.header", new String[]{company.getName()});
        standardTemplate.addTemplate(new CompanySpecTemplate(company));
        FileEditTemplate fileEdit = standardTemplate.addTemplate(new FileEditTemplate());
        fileEdit.setFile(file);
        fileEdit.setFormAction(AppPaths.CONTACTS_COMPANY_FILE_EDIT_2 + "?companyId=" + companyId + "&fileId=" + fileId);
        fileEdit.setFormCancelAction(AppPaths.CONTACTS_COMPANY_FILES + "?companyId=" + companyId);
        ActionErrorsTemplate errorsTemplate = fileEdit.getErrorsTemplate();
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String edit2() throws Exception {
        FileUploadForm actionForm = this.saveActionForm(new FileUploadForm());
        Integer companyId = this.requestContext.getParameter("companyId");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Company company = contactService.getCompany(companyId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = contactService.getCompanyFile(companyId, fileId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        ActionMessages errors = fileService.updateFile(file, actionForm);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_FILE_EDIT + "?companyId=" + company.getId() + "&fileId=" + fileId + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_FILES + "?companyId=" + companyId);
    }
}

