/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.contacts.CompanyForm;
import com.kwoksys.action.contacts.CompanySpecTemplate;
import com.kwoksys.action.issues.IssueListTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.dto.linking.CompanyIssueLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;

public class CompanyIssueAction
extends Action2 {
    public String list() throws Exception {
        AccessUser user = this.requestContext.getUser();
        CompanyForm actionForm = this.getBaseForm(CompanyForm.class);
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Company company = contactService.getCompany(actionForm.getCompanyId());
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(ContactQueries.getOrderByColumn("creation_date"));
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("contactMgmt.companyDetail.header", new Object[]{company.getName()});
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_ISSUE_ADD)) {
            header.addHeaderCmds(new Link(this.requestContext).setAjaxPath(AppPaths.CONTACTS_COMPANY_ISSUE_ADD + "?companyId=" + actionForm.getCompanyId()).setTitleKey("contactMgmt.cmd.companyIssueAdd"));
        }
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_LIST)) {
            header.addHeaderCmds(new Link(this.requestContext).setAjaxPath(AppPaths.CONTACTS_COMPANY_LIST).setTitleKey("contactMgmt.cmd.companyList"));
        }
        standardTemplate.addTemplate(new CompanySpecTemplate(company));
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(CompanyUtils.getCompanyTabs(this.requestContext, company));
        tabs.setTabActive("issueTab");
        IssueListTemplate listTemplate = standardTemplate.addTemplate(new IssueListTemplate());
        listTemplate.setAccessUser(user);
        listTemplate.setQueryCriteria(queryCriteria);
        listTemplate.setObjectMap(new CompanyIssueLink(actionForm.getCompanyId()).createObjectMap());
        listTemplate.setFormRemoveItemAction(AppPaths.CONTACTS_COMPANY_ISSUE_REMOVE_2);
        listTemplate.setColumnHeaders(IssueUtils.getIssueColumnHeaders());
        listTemplate.setEmptyTableRowKey("issueMgmt.issueList.emptyTableMessage");
        listTemplate.getFormHiddenVariableMap().put("companyId", String.valueOf(company.getId()));
        listTemplate.setFormRowIdName("issueId");
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String remove2() throws Exception {
        Integer companyId = this.requestContext.getParameter("companyId");
        Integer issueId = this.requestContext.getParameter("issueId");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        contactService.getCompany(companyId);
        CompanyIssueLink issueMap = new CompanyIssueLink();
        issueMap.setCompanyId(companyId);
        issueMap.setIssueId(issueId);
        ActionMessages errors = contactService.deleteCompanyIssue(issueMap);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_ISSUES + "?companyId=" + companyId + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_ISSUES + "?companyId=" + companyId);
    }
}

