/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.contacts.ContactSearchForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.CompanySearch;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.List;

public class CompanyListAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        ContactSearchForm actionForm = this.getSessionBaseForm(ContactSearchForm.class);
        AccessUser user = this.requestContext.getUser();
        String cmd = this.requestContext.getParameterString("cmd");
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "COMPANIES_ORDER_BY", "company_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "COMPANIES_ORDER", "asc");
        int rowStart = 0;
        if (!cmd.isEmpty() || rowCmd.equals("showAll")) {
            this.request.getSession().setAttribute("COMPANIES_ROW_START", (Object)rowStart);
        } else {
            rowStart = SessionManager.getOrSetAttribute(this.requestContext, "rowStart", "COMPANIES_ROW_START", rowStart);
        }
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getCompanyRows());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        CompanySearch companySearch = new CompanySearch(this.requestContext, "COMPANY_SEARCH_CRITERIA_MAP");
        if (!cmd.isEmpty()) {
            companySearch.reset();
            actionForm.setRequest(this.requestContext);
            if (cmd.equals("search")) {
                companySearch.prepareMap(actionForm);
            } else if (cmd.equals("showAll")) {
                // empty if block
            }
            companySearch.put("cmd", cmd);
        }
        QueryCriteria queryCriteria = new QueryCriteria(companySearch);
        queryCriteria.setLimit(rowLimit, rowStart);
        if (Company.isSortableCompanyColumn(orderBy)) {
            queryCriteria.addSortColumn(ContactQueries.getOrderByColumn(orderBy), order);
        }
        List<String> columnHeaders = ConfigManager.app.getContactsCompanyColumnList();
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        int rowCount = contactService.getCompanyCount(queryCriteria);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("contactMgmt.companyList.title");
        header.setTitleClassNoLine();
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_ADD)) {
            link = new Link(this.requestContext).setAjaxPath(AppPaths.CONTACTS_COMPANY_ADD).setTitleKey("contactMgmt.cmd.companyAdd");
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_LIST_EXPORT)) {
            link = new Link(this.requestContext).setExportPath(AppPaths.CONTACTS_COMPANY_LIST_EXPORT).setTitleKey("contacts.cmd.companyExport").setInlineImage(Image.getInstance().getFileCsvIcon());
            header.addHeaderCmds(link);
        }
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        if (companySearch.getSearchCriteriaMap().containsKey("cmd") && companySearch.getSearchCriteriaMap().get("cmd").equals("search")) {
            nav.setInfoText(Localizer.getText(this.requestContext, "contactMgmt.companyList.searchResult"));
        }
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "contactMgmt.companyList.rowCount", new Object[]{rowCount}));
        nav.setShowAllRecordsPath(AppPaths.CONTACTS_COMPANY_LIST + "?rowCmd=showAll");
        nav.setPath(AppPaths.CONTACTS_COMPANY_LIST + "?rowStart=");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setSortableColumnHeaders(Company.getSortableCompanyColumnList());
        tableTemplate.setColumnPath(AppPaths.CONTACTS_COMPANY_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(rowCmd);
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setEmptyRowMsgKey("contactMgmt.companyList.emptyTableMessage");
        if (rowCount != 0) {
            List<Company> companyDataset = contactService.getCompanies(queryCriteria);
            Counter counter = new Counter(rowStart);
            List<DataRow> dataList = CompanyUtils.formatCompanyList(this.requestContext, companyDataset, counter);
            tableTemplate.setDataList(dataList);
        }
        return standardTemplate.findTemplate("standard_autogen_template");
    }
}

