/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.CompanySearch;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.reports.writers.CsvReportWriter;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import java.util.ArrayList;
import java.util.List;

public class CompanyListExportAction
extends Action2 {
    public String execute() throws Exception {
        String orderBy = SessionManager.getAttribute(this.request, "COMPANIES_ORDER_BY", "company_name");
        String order = SessionManager.getAttribute(this.request, "COMPANIES_ORDER", "asc");
        CompanySearch companySearch = new CompanySearch(this.requestContext, "COMPANY_SEARCH_CRITERIA_MAP");
        QueryCriteria queryCriteria = new QueryCriteria(companySearch);
        if (Company.isSortableCompanyColumn(orderBy)) {
            queryCriteria.addSortColumn(ContactQueries.getOrderByColumn(orderBy), order);
        }
        List<String> columnKeys = ConfigManager.app.getContactsCompanyExportColumns();
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        ResponseContext responseContext = new ResponseContext(this.response);
        responseContext.setAttachementName(Localizer.getText(this.requestContext, "contacts.companyListExport.filename"));
        CsvReportWriter csvReportWriter = new CsvReportWriter();
        csvReportWriter.init(responseContext);
        ArrayList<String> columnHeaders = new ArrayList<String>();
        for (String column : columnKeys) {
            columnHeaders.add(Localizer.getText(this.requestContext, "common.column." + column));
        }
        csvReportWriter.addHeaderRow(columnHeaders);
        List<Company> companyDataset = contactService.getCompanies(queryCriteria);
        for (Company company : companyDataset) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : columnKeys) {
                if (column.equals("company_name")) {
                    columns.add(company.getName());
                    continue;
                }
                if (!column.equals("company_description")) continue;
                columns.add(company.getDescription());
            }
            csvReportWriter.addRow(columns);
        }
        return csvReportWriter.close();
    }
}

