/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableEmptyTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.contacts.CompanyNoteAddForm;
import com.kwoksys.action.contacts.CompanySpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.contacts.dto.CompanyNote;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CompanyNoteAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        AccessUser user = this.requestContext.getUser();
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        Integer companyId = this.requestContext.getParameter("companyId");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Company company = contactService.getCompany(companyId);
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(ContactQueries.getOrderByColumn("creation_date"), "desc");
        List<CompanyNote> notesDataset = contactService.getCompanyNotes(queryCriteria, company.getId());
        ArrayList notes = new ArrayList();
        if (!notesDataset.isEmpty()) {
            for (CompanyNote companyNote : notesDataset) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", companyNote.getNoteId());
                map.put("subject", companyNote.getNoteName());
                map.put("description", HtmlUtils.formatMultiLineDisplay(companyNote.getNoteDescription()));
                map.put("type", attributeManager.getAttrFieldNameCache(Attributes.COMPANY_NOTE_TYPE, companyNote.getNoteTypeId()));
                map.put("creationDate", companyNote.getCreationDate());
                notes.add(map);
            }
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("companyId", company.getId());
        standardTemplate.setAttribute("notes", notes);
        standardTemplate.setAttribute("companyNotePath", AppPaths.CONTACTS_COMPANY_NOTE);
        standardTemplate.addTemplate(new CompanySpecTemplate(company));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("contactMgmt.companyDetail.header", new Object[]{company.getName()});
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_NOTE_ADD)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_COMPANY_NOTE_ADD + "?companyId=" + company.getId());
            link.setTitleKey("contactMgmt.cmd.contactAddNote");
            link.setInlineImage(Image.getInstance().getNoteAddIcon());
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_COMPANY_LIST);
            link.setTitleKey("contactMgmt.cmd.companyList");
            header.addHeaderCmds(link);
        }
        if (notesDataset.isEmpty()) {
            TableEmptyTemplate empty = standardTemplate.addTemplate(new TableEmptyTemplate());
            empty.setColSpan(3);
            empty.setRowText(Localizer.getText(this.requestContext, "contactMgmt.companyNote_emptyTableMessage"));
        }
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(CompanyUtils.getCompanyTabs(this.requestContext, company));
        tabs.setTabActive("noteTab");
        return standardTemplate.findTemplate("standard_template");
    }

    public String add() throws Exception {
        CompanyNoteAddForm actionForm = this.getBaseForm(CompanyNoteAddForm.class);
        actionForm.setId("companyNoteAddForm");
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Company company = contactService.getCompany(actionForm.getCompanyId());
        CompanyNote note = new CompanyNote(company.getId());
        if (!actionForm.isResubmit()) {
            actionForm.setNote(note);
        }
        note.loadAttrs(this.requestContext);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("companyId", company.getId());
        standardTemplate.setPathAttribute("formAction", AppPaths.CONTACTS_COMPANY_NOTE_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.CONTACTS_COMPANY_NOTE + "?companyId=" + company.getId()).getString());
        standardTemplate.setAttribute("noteTypeOptions", new AttributeManager(this.requestContext).setOptional(true).getActiveAttrFieldOptionsCache(Attributes.COMPANY_NOTE_TYPE));
        standardTemplate.addTemplate(new CompanySpecTemplate(company));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("contactMgmt.companyDetail.header", new Object[]{company.getName()});
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        CompanyNoteAddForm actionForm = this.saveActionForm(new CompanyNoteAddForm());
        Integer companyId = actionForm.getCompanyId();
        contactService.getCompany(companyId);
        CompanyNote note = new CompanyNote(companyId);
        note.setNoteName(actionForm.getNoteName());
        note.setNoteDescription(actionForm.getNoteDescription());
        note.setNoteTypeId(actionForm.getNoteType());
        note.setCompanyId(companyId);
        ActionMessages errors = contactService.addCompanyNote(note);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_NOTE_ADD + "?companyId=" + companyId + "&" + "_error=true");
        }
        contactService.resetCompanyNoteCount(companyId);
        return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_NOTE + "?companyId=" + companyId + "&noteId=" + note.getNoteId());
    }
}

