/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.DetailTableTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.WidgetUtils;
import com.kwoksys.framework.util.HtmlUtils;
import com.kwoksys.framework.util.StringUtils;
import com.kwoksys.framework.util.UrlUtils;
import java.util.ArrayList;
import java.util.Map;

public class CompanySpecTemplate
extends BaseTemplate {
    private DetailTableTemplate detailTableTemplate = new DetailTableTemplate();
    private Company company;
    private boolean populateCompanyTagList;

    public CompanySpecTemplate(Company company) {
        super(CompanySpecTemplate.class);
        this.company = company;
    }

    @Override
    public void init() {
        this.addTemplate(this.detailTableTemplate);
    }

    @Override
    public void applyTemplate() throws Exception {
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        DetailTableTemplate.Td td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.company_id");
        td.setValue(String.valueOf(this.company.getId()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.company_name");
        td.setValue(HtmlUtils.encode(this.company.getName()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.company_description");
        td.setValue(HtmlUtils.formatMultiLineDisplay(this.company.getDescription()));
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        this.company.setTypeIds(contactService.getCompanyTypes(this.company.getId()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.company_types");
        if (!this.company.getTypeIds().isEmpty()) {
            ArrayList<String> types = new ArrayList<String>();
            for (Integer typeId : this.company.getTypeIds()) {
                types.add(attributeManager.getAttrFieldNameCache(Attributes.COMPANY_TYPES, typeId));
            }
            td.setValue(StringUtils.join(types, ", "));
        }
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.creator");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.company.getCreationDate(), this.company.getCreator()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.modifier");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.company.getModificationDate(), this.company.getModifier()));
        if (this.populateCompanyTagList) {
            QueryCriteria tagQuery = new QueryCriteria();
            tagQuery.addSortColumn(ContactQueries.getOrderByColumn("tag_name"));
            StringBuilder tags = new StringBuilder();
            for (Map<String, String> map : contactService.getCompanyTags(tagQuery, this.company.getId())) {
                tags.append(new Link(this.requestContext).setTitle(map.get("tag_name")).setAjaxPath(AppPaths.CONTACTS_COMPANY_LIST + "?cmd=search&companyTag=" + UrlUtils.encode(map.get("tag_name"))).getString()).append("&nbsp; ");
            }
            td = this.detailTableTemplate.newTd();
            td.setHeaderKey("common.column.company_tags");
            td.setValue(tags.toString());
        }
    }

    @Override
    public String getJspPath() {
        return "/jsp/contacts/CompanySpecTemplate.jsp";
    }

    public String getCompanyHeaderText() {
        return Localizer.getText(this.requestContext, "contactMgmt.companyDetail.header", (Object[])new String[]{this.company.getName()});
    }

    public void setPopulateCompanyTagList(boolean populateCompanyTagList) {
        this.populateCompanyTagList = populateCompanyTagList;
    }
}

