/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.ContactSearch;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContactAssociateTemplate
extends BaseTemplate {
    private Integer contactId;
    private String formContactId;
    private String formSearchAction;
    private String formSaveAction;
    private String formCancelAction;
    private List<Map<String, String>> contactList = new ArrayList<Map<String, String>>();

    public ContactAssociateTemplate() {
        super(ContactAssociateTemplate.class);
    }

    @Override
    public void init() {
        this.addTemplate(new ActionErrorsTemplate());
    }

    @Override
    public void applyTemplate() throws DatabaseException {
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        if (!this.formContactId.isEmpty()) {
            ContactSearch contactSearch = new ContactSearch();
            contactSearch.put("contactIdEquals", this.formContactId);
            contactSearch.put("companyContactType", ObjectTypes.COMPANY_EMPLOYEE_CONTACT);
            QueryCriteria queryCriteria = new QueryCriteria(contactSearch);
            List<Contact> contacts = contactService.getContacts(queryCriteria);
            if (!contacts.isEmpty()) {
                Contact contact = contacts.iterator().next();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("contactId", String.valueOf(contact.getId()));
                this.contactId = contact.getId();
                StringBuilder contactDisplay = new StringBuilder();
                contactDisplay.append(contact.getLastName()).append(", ").append(contact.getFirstName());
                if (!contact.getEmailPrimary().isEmpty()) {
                    contactDisplay.append(" (").append(contact.getEmailPrimary()).append(")");
                }
                map.put("contactName", contactDisplay.toString());
                this.contactList.add(map);
            }
        }
        if (this.formContactId.isEmpty()) {
            this.request.setAttribute("selectContactMessage", (Object)"form.noSearchInput");
        } else if (this.contactList.isEmpty()) {
            this.request.setAttribute("selectContactMessage", (Object)"form.noSearchResult");
        }
    }

    @Override
    public String getJspPath() {
        return "/jsp/contacts/ContactAssociateTemplate.jsp";
    }

    public void setFormSaveAction(String formSaveAction) {
        this.formSaveAction = AppPaths.ROOT + formSaveAction;
    }

    public String getFormContactId() {
        return this.formContactId;
    }

    public void setFormContactId(String formContactId) {
        this.formContactId = formContactId;
    }

    public void setFormSearchAction(String formSearchAction) {
        this.formSearchAction = AppPaths.ROOT + formSearchAction;
    }

    public void setFormCancelAction(String formCancelAction) {
        this.formCancelAction = formCancelAction;
    }

    public String getFormSearchAction() {
        return this.formSearchAction;
    }

    public String getFormSaveAction() {
        return this.formSaveAction;
    }

    public String getFormCancelLink() {
        return Links.getCancelLink(this.requestContext, this.formCancelAction).getString();
    }

    public Integer getContactId() {
        return this.contactId;
    }

    public String getDisableSaveButton() {
        return this.contactList.isEmpty() ? "disabled" : "";
    }

    public List<Map<String, String>> getContactList() {
        return this.contactList;
    }
}

