/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.contacts.EmployeeContactSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;

public class ContactDetailAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        Integer contactId = this.requestContext.getParameter("contactId");
        AccessUser user = this.requestContext.getUser();
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Contact contact = contactService.getContact(contactId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        this.request.setAttribute("contactId", (Object)contactId);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("contactMgmt.contactDetail.title");
        if (contact.getUserId() != 0) {
            if (Access.hasPermission(user, AppPaths.ADMIN_USER_DETAIL)) {
                link = new Link(this.requestContext);
                link.setAjaxPath(AppPaths.ADMIN_USER_DETAIL + "?userId=" + contact.getUserId());
                link.setTitleKey("contactMgmt.cmd.contactViewUser");
                header.addHeaderCmds(link);
            } else if (Access.hasPermission(user, AppPaths.CONTACTS_CONTACT_DELETE)) {
                link = new Link(this.requestContext);
                link.setTitleKey("contactMgmt.cmd.contactDeleteNoPermission");
                header.addHeaderCmds(link);
            }
        } else {
            if (Access.hasPermission(user, AppPaths.CONTACTS_CONTACT_EDIT)) {
                link = new Link(this.requestContext);
                link.setAjaxPath(AppPaths.CONTACTS_CONTACT_EDIT + "?contactId=" + contactId);
                link.setTitleKey("contactMgmt.contactEdit.title");
                header.addHeaderCmds(link);
            }
            if (Access.hasPermission(user, AppPaths.CONTACTS_CONTACT_DELETE)) {
                link = new Link(this.requestContext);
                link.setAjaxPath(AppPaths.CONTACTS_CONTACT_DELETE + "?contactId=" + contactId);
                link.setTitleKey("contactMgmt.contactDelete.title");
                header.addHeaderCmds(link);
            }
            if (Access.hasPermission(user, AppPaths.ADMIN_USER_ADD)) {
                link = new Link(this.requestContext);
                link.setAjaxPath(AppPaths.ADMIN_USER_ADD + "?contactId=" + contact.getId());
                link.setTitleKey("contactMgmt.cmd.contactAddUser");
                header.addHeaderCmds(link);
            }
        }
        if (Access.hasPermission(user, AppPaths.CONTACTS_CONTACT_EXPORT_VCARD)) {
            link = new Link(this.requestContext);
            link.setExportPath(AppPaths.CONTACTS_CONTACT_EXPORT_VCARD + "?contactId=" + contactId);
            link.setInlineImage(Image.getInstance().getVCardIcon());
            link.setTitleKey("contactMgmt.cmd.contactExport");
            header.addHeaderCmds(link);
        }
        if (contact.getCompanyId() != 0 && Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_CONTACT)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_COMPANY_CONTACT + "?companyId=" + contact.getCompanyId());
            link.setTitleKey("contactMgmt.cmd.companyDetail");
            header.addHeaderCmds(link);
        }
        EmployeeContactSpecTemplate tmpl = standardTemplate.addTemplate(new EmployeeContactSpecTemplate());
        tmpl.setContactDetailHeader(Localizer.getText(this.requestContext, "contactMgmt.contactDetail.title"));
        tmpl.setContact(contact);
        return standardTemplate.findTemplate("standard_autogen_template");
    }
}

