/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.contacts.ContactForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;

public class ContactEditAction
extends Action2 {
    public String edit() throws Exception {
        ContactForm actionForm = this.getBaseForm(ContactForm.class);
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Contact contact = contactService.getContact(actionForm.getContactId());
        if (!actionForm.isResubmit()) {
            actionForm.setContact(contact);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.CONTACTS_CONTACT_EDIT_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.CONTACTS_CONTACT_DETAIL + "?contactId=" + contact.getId()).getString());
        standardTemplate.setAttribute("companyIdOptions", CompanyUtils.getCompanyOptions(this.requestContext));
        standardTemplate.setAttribute("messenger1TypeOptions", new AttributeManager(this.requestContext).setOptional(true).setSelectedAttrFieldId(contact.getMessenger1Type()).getActiveAttrFieldOptionsCache(Attributes.CONTACT_IM));
        standardTemplate.setAttribute("messenger2TypeOptions", new AttributeManager(this.requestContext).setOptional(true).setSelectedAttrFieldId(contact.getMessenger2Type()).getActiveAttrFieldOptionsCache(Attributes.CONTACT_IM));
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setTitleKey("contactMgmt.contactEdit.title");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        errorsTemplate.setMessageKey("contactMgmt.contactEdit.sectionHeader");
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        ContactForm actionForm = this.saveActionForm(new ContactForm());
        Contact contact = new Contact();
        contact.setContactId(actionForm.getContactId());
        contact.setFirstName(actionForm.getContactFirstName());
        contact.setLastName(actionForm.getContactLastName());
        contact.setTitle(actionForm.getContactTitle());
        contact.setCompanyId(actionForm.getCompanyId());
        contact.setPhoneHome(actionForm.getContactPhoneHome());
        contact.setPhoneMobile(actionForm.getContactPhoneMobile());
        contact.setPhoneWork(actionForm.getContactPhoneWork());
        contact.setFax(actionForm.getContactFax());
        contact.setEmailPrimary(actionForm.getContactEmailPrimary());
        contact.setEmailSecondary(actionForm.getContactEmailSecondary());
        contact.setMessenger1Id(actionForm.getMessenger1Id());
        contact.setMessenger1Type(actionForm.getMessenger1Type());
        contact.setMessenger2Id(actionForm.getMessenger2Id());
        contact.setMessenger2Type(actionForm.getMessenger2Type());
        contact.setHomepageUrl(actionForm.getContactHomepageUrl());
        contact.setDescription(actionForm.getContactDescription());
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        ActionMessages errors = contactService.updateEmployeeContact(contact);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTACTS_CONTACT_EDIT + "?contactId=" + contact.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.CONTACTS_CONTACT_DETAIL + "?contactId=" + contact.getId());
    }
}

