/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.contacts.ContactSearchForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.ContactSearch;
import com.kwoksys.biz.contacts.core.ContactUtils;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import java.util.Map;

public class ContactListAction
extends Action2 {
    public String execute() throws Exception {
        ContactSearchForm actionForm = this.getSessionBaseForm(ContactSearchForm.class);
        String cmd = this.requestContext.getParameterString("cmd");
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "CONTACTS_ORDER_BY", "contact_first_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "CONTACTS_ORDER", "asc");
        int rowStart = 0;
        if (!cmd.isEmpty() || rowCmd.equals("showAll")) {
            this.request.getSession().setAttribute("CONTACTS_ROW_START", (Object)rowStart);
        } else {
            rowStart = SessionManager.getOrSetAttribute(this.requestContext, "rowStart", "CONTACTS_ROW_START", rowStart);
        }
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getContactRows());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        HttpSession session = this.request.getSession();
        ContactSearch contactSearch = new ContactSearch();
        if (!cmd.isEmpty()) {
            if (cmd.equals("search")) {
                contactSearch.prepareMap(actionForm);
                contactSearch.put("companyContactType", ObjectTypes.COMPANY_EMPLOYEE_CONTACT);
            } else if (cmd.equals("showAll")) {
                // empty if block
            }
            contactSearch.put("cmd", cmd);
            session.setAttribute("CONTACT_SEARCH_CRITERIA_MAP", contactSearch.getSearchCriteriaMap());
        } else if (session.getAttribute("CONTACT_SEARCH_CRITERIA_MAP") != null) {
            contactSearch.setSearchCriteriaMap((Map)session.getAttribute("CONTACT_SEARCH_CRITERIA_MAP"));
        }
        QueryCriteria queryCriteria = new QueryCriteria(contactSearch);
        queryCriteria.setLimit(rowLimit, rowStart);
        if (ContactUtils.isSortableColumn(orderBy)) {
            queryCriteria.addSortColumn(ContactQueries.getOrderByColumn(orderBy), order);
        }
        List<String> columnHeaders = ContactUtils.getContactColumnHeader();
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        int rowCount = contactService.getContactCount(queryCriteria);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setTitleKey("contactMgmt.contactList.title");
        headerTemplate.setTitleClassNoLine();
        RecordsNavigationTemplate recordNavTemplate = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        recordNavTemplate.setInfoText(Localizer.getText(this.requestContext, "contactMgmt.contactList.searchResult"));
        recordNavTemplate.setRowOffset(rowStart);
        recordNavTemplate.setRowLimit(rowLimit);
        recordNavTemplate.setRowCount(rowCount);
        recordNavTemplate.setRowCountMsgkey("core.template.recordsNav.rownum");
        recordNavTemplate.setShowAllRecordsText(Localizer.getText(this.requestContext, "contactMgmt.contactList.rowCount", new Object[]{rowCount}));
        recordNavTemplate.setShowAllRecordsPath(AppPaths.CONTACTS_CONTACT_LIST + "?rowCmd=showAll");
        recordNavTemplate.setPath(AppPaths.CONTACTS_CONTACT_LIST + "?rowStart=");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setSortableColumnHeaders(ContactUtils.getSortableContactColumnList());
        tableTemplate.setColumnPath(AppPaths.CONTACTS_CONTACT_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(null);
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setEmptyRowMsgKey("contactMgmt.contactList.emptyTableMessage");
        if (rowCount != 0) {
            Counter counter = new Counter(rowStart);
            List<Contact> contacts = contactService.getContacts(queryCriteria);
            List<DataRow> dataList = ContactUtils.formatContacts(this.requestContext, contacts, columnHeaders, counter);
            tableTemplate.setDataList(dataList);
        }
        return standardTemplate.findTemplate("standard_autogen_template");
    }
}

