/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.DetailTableTemplate;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.ui.WidgetUtils;
import com.kwoksys.framework.util.HtmlUtils;

public class EmployeeContactSpecTemplate
extends BaseTemplate {
    private DetailTableTemplate detailTableTemplate = new DetailTableTemplate();
    private String contactDetailHeader;
    private Contact contact;

    public EmployeeContactSpecTemplate() {
        super(EmployeeContactSpecTemplate.class);
    }

    @Override
    public void init() {
        this.addTemplate(this.detailTableTemplate);
    }

    @Override
    public void applyTemplate() throws Exception {
        this.detailTableTemplate.setNumColumns(2);
        DetailTableTemplate.Td td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_id");
        td.setValue(String.valueOf(this.contact.getId()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.company_name");
        td.setValue(Links.getCompanyDetailsLink(this.requestContext, this.contact.getCompanyName(), this.contact.getCompanyId()).getString());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_first_name");
        td.setValue(HtmlUtils.encode(this.contact.getFirstName()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_last_name");
        td.setValue(HtmlUtils.encode(this.contact.getLastName()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_title");
        td.setValue(HtmlUtils.encode(this.contact.getTitle()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_phone_work");
        td.setValue(HtmlUtils.encode(this.contact.getPhoneWork()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_phone_home");
        td.setValue(HtmlUtils.encode(this.contact.getPhoneHome()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_phone_mobile");
        td.setValue(HtmlUtils.encode(this.contact.getPhoneMobile()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_fax");
        td.setValue(HtmlUtils.encode(this.contact.getFax()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_email_primary");
        td.setValue(HtmlUtils.formatMailtoLink(this.contact.getEmailPrimary()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_email_secondary");
        td.setValue(HtmlUtils.formatMailtoLink(this.contact.getEmailSecondary()));
        td = this.detailTableTemplate.newTd();
        if (this.contact.getMessenger1TypeAttribute(this.requestContext).isEmpty()) {
            td.setHeaderKey("common.column.contact_im");
        } else {
            td.setHeaderText(Localizer.getText(this.requestContext, "common.column.contact_im_not_null", (Object[])new String[]{HtmlUtils.encode(this.contact.getMessenger1TypeAttribute(this.requestContext))}));
        }
        td.setValue(HtmlUtils.encode(this.contact.getMessenger1Id()));
        td = this.detailTableTemplate.newTd();
        if (this.contact.getMessenger2TypeAttribute(this.requestContext).isEmpty()) {
            td.setHeaderKey("common.column.contact_im");
        } else {
            td.setHeaderText(Localizer.getText(this.requestContext, "common.column.contact_im_not_null", (Object[])new String[]{HtmlUtils.encode(this.contact.getMessenger2TypeAttribute(this.requestContext))}));
        }
        td.setValue(HtmlUtils.encode(this.contact.getMessenger2Id()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_homepage_url");
        td.setValue(HtmlUtils.formatExternalLink(this.requestContext, this.contact.getHomepageUrl()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contact_description");
        td.setValue(HtmlUtils.formatMultiLineDisplay(this.contact.getDescription()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.creator");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.contact.getCreationDate(), this.contact.getCreator()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.modifier");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.contact.getModificationDate(), this.contact.getModifier()));
        this.request.setAttribute("TemplateContactSpec_contactDetailHeader", (Object)this.contactDetailHeader);
    }

    @Override
    public String getJspPath() {
        return "/jsp/contacts/ContactSpecTemplate.jsp";
    }

    public void setContactDetailHeader(String contactDetailHeader) {
        this.contactDetailHeader = contactDetailHeader;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }
}

