/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contacts;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.contacts.ContactSearchForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.UrlUtils;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Map;

public class IndexAction
extends Action2 {
    public String execute() throws Exception {
        this.getSessionBaseForm(ContactSearchForm.class);
        AccessUser user = this.requestContext.getUser();
        HttpSession session = this.request.getSession();
        ArrayList<String> links = new ArrayList<String>();
        String companySearchAction = "";
        if (user.hasPermission(AppPaths.CONTACTS_COMPANY_LIST)) {
            if (session.getAttribute("COMPANY_SEARCH_CRITERIA_MAP") != null) {
                links.add(new Link(this.requestContext).setAjaxPath(AppPaths.CONTACTS_COMPANY_LIST).setTitleKey("common.search.showLastSearch").getString());
            }
            links.add(new Link(this.requestContext).setAjaxPath(AppPaths.CONTACTS_COMPANY_LIST + "?cmd=showAll").setTitleKey("contactMgmt.index.companyList").getString());
            companySearchAction = AppPaths.ROOT + AppPaths.CONTACTS_COMPANY_LIST;
        }
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(ContactQueries.getOrderByColumn("creation_date"), "desc");
        queryCriteria.setLimit(30, 0);
        String contactSearchAction = user.hasPermission(AppPaths.CONTACTS_CONTACT_LIST) ? AppPaths.ROOT + AppPaths.CONTACTS_CONTACT_LIST : "";
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        ArrayList<String> companyTagLinks = new ArrayList<String>();
        for (Map<String, String> map : contactService.getExistingCompanyTags(queryCriteria)) {
            companyTagLinks.add(new Link(this.requestContext).setTitle(map.get("tag_name")).setAjaxPath(AppPaths.CONTACTS_COMPANY_LIST + "?cmd=search&companyTag=" + UrlUtils.encode(map.get("tag_name"))).getString());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("customFieldsOptions", new AttributeManager(this.requestContext).getCustomFieldOptions(ObjectTypes.COMPANY));
        standardTemplate.setAttribute("formCompanySearchAction", companySearchAction);
        standardTemplate.setAttribute("formContactSearchAction", contactSearchAction);
        standardTemplate.setAttribute("companyTagLinks", companyTagLinks);
        standardTemplate.setAttribute("linkList", links);
        standardTemplate.setAttribute("numCompanyRecords", contactService.getCompanyCount(new QueryCriteria()));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("core.moduleName.5");
        header.setTitleClassNoLine();
        if (user.hasPermission(AppPaths.CONTACTS_COMPANY_ADD)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTACTS_COMPANY_ADD);
            link.setTitleKey("contactMgmt.cmd.companyAdd");
            header.addHeaderCmds(link);
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

