/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contracts;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.contracts.ContractForm;
import com.kwoksys.action.contracts.ContractSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.CalendarUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contracts.ContractService;
import com.kwoksys.biz.contracts.core.ContractUtils;
import com.kwoksys.biz.contracts.dto.Contract;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.core.FileUtils;
import com.kwoksys.biz.files.dao.FileQueries;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ContractAction
extends Action2 {
    public String detail() throws Exception {
        Link link;
        AccessUser user = this.requestContext.getUser();
        Integer contractId = this.requestContext.getParameter("contractId");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "FILES_ORDER_BY", "file_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "FILES_ORDER", "asc");
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(contractId);
        String fileDownloadPath = AppPaths.CONTRACTS_FILE_DOWNLOAD + "?contractId=" + contractId + "&fileId=";
        String fileDeletePath = AppPaths.CONTRACTS_FILE_DELETE + "?contractId=" + contractId + "&fileId=";
        String fileEditPath = AppPaths.CONTRACTS_FILE_EDIT + "?contractId=" + contractId + "&fileId=";
        boolean canDeleteFile = user.hasPermission(AppPaths.CONTRACTS_FILE_DELETE);
        boolean canDownloadFile = user.hasPermission(AppPaths.CONTRACTS_FILE_DOWNLOAD);
        QueryCriteria queryCriteria = new QueryCriteria();
        if (FileUtils.isSortableColumn(orderBy)) {
            queryCriteria.addSortColumn(FileQueries.getOrderByColumn(orderBy), order);
        }
        List<File> fileList = contractService.getContractFiles(queryCriteria, contractId);
        ArrayList<String> columnHeaders = new ArrayList<String>(FileUtils.getFileColumnHeaders());
        if (canDeleteFile) {
            columnHeaders.add("command");
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.contractDetail.header", new String[]{contract.getName()});
        if (user.hasPermission(AppPaths.CONTRACTS_EDIT)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTRACTS_EDIT + "?contractId=" + contractId);
            link.setTitleKey("itMgmt.cmd.contractEdit");
            header.addHeaderCmds(link);
        }
        if (user.hasPermission(AppPaths.CONTRACTS_DELETE)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTRACTS_DELETE + "?contractId=" + contractId);
            link.setTitleKey("itMgmt.cmd.contractDelete");
            header.addHeaderCmds(link);
        }
        if (user.hasPermission(AppPaths.CONTRACTS_FILE_ADD)) {
            link = new Link(this.requestContext);
            link.setTitleKey("files.fileAttach");
            if (fileService.isDirectoryExist(ConfigManager.file.getContractFileRepositoryLocation())) {
                link.setAjaxPath(AppPaths.CONTRACTS_FILE_ADD + "?contractId=" + contractId);
                link.setInlineImage(Image.getInstance().getFileAddIcon());
            } else {
                link.setInlineImage(Image.getInstance().getWarning(Localizer.getText(this.requestContext, "files.warning.invalidPath")));
            }
            header.addHeaderCmds(link);
        }
        link = new Link(this.requestContext);
        link.setAjaxPath(AppPaths.CONTRACTS_LIST);
        link.setTitleKey("itMgmt.cmd.contractList");
        header.addHeaderCmds(link);
        standardTemplate.addTemplate(new ContractSpecTemplate(contract));
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.CONTRACT);
        customFieldsTemplate.setObjectId(contractId);
        customFieldsTemplate.setObjectAttrTypeId(contract.getType());
        customFieldsTemplate.setShowDefaultHeader(false);
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(ContractUtils.contractTabList(this.requestContext, contract));
        tabs.setTabActive("filesTab");
        TableTemplate tableHeader = standardTemplate.addTemplate(new TableTemplate());
        tableHeader.setColumnPath(AppPaths.CONTRACTS_DETAIL + "?contractId=" + contractId);
        tableHeader.setColumnHeaders(columnHeaders);
        tableHeader.setColumnTextKey("files.colName.");
        tableHeader.setSortableColumnHeaders(FileUtils.getSortableColumns());
        tableHeader.setOrderBy(orderBy);
        tableHeader.setOrder(order);
        tableHeader.setEmptyRowMsgKey("files.noAttachments");
        if (!fileList.isEmpty()) {
            Counter counter = new Counter();
            for (File file : fileList) {
                ArrayList<String> columns = new ArrayList<String>();
                columns.add(counter.incr() + ".");
                columns.add(Links.getFileIconLink(this.requestContext, canDownloadFile, file.getLogicalName(), fileDownloadPath + file.getId()).getString());
                columns.add(HtmlUtils.encode(file.getTitle()));
                columns.add(file.getCreationDate());
                columns.add(FileUtils.formatFileSize(this.requestContext, file.getSize()));
                if (canDeleteFile) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(new Link(this.requestContext).setAjaxPath(fileEditPath + file.getId()).setTitleKey("common.action.Edit").getString());
                    sb.append(" | ");
                    sb.append(new Link(this.requestContext).setAjaxPath(fileDeletePath + file.getId()).setTitleKey("common.action.Delete").getString());
                    columns.add(sb.toString());
                }
                tableHeader.addRow(columns);
            }
        }
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add() throws Exception {
        ContractForm actionForm = this.getBaseForm(ContractForm.class);
        actionForm.setId("contractAddForm");
        Contract contract = new Contract();
        contract.loadAttrs(this.requestContext);
        if (!actionForm.isResubmit()) {
            actionForm.setContract(contract);
        }
        List<LabelValueBean> typeOptions = new AttributeManager(this.requestContext).setOptional(true).getActiveAttrFieldOptionsCache(Attributes.CONTRACT_TYPE);
        List<LabelValueBean> contractStageOptions = new AttributeManager(this.requestContext).setOptional(true).getActiveAttrFieldOptionsCache(Attributes.CONTRACT_STAGE);
        List<LabelValueBean> renewalOptions = new AttributeManager(this.requestContext).setOptional(true).getActiveAttrFieldOptionsCache(Attributes.CONTRACT_RENEWAL_TYPE);
        ArrayList<LabelValueBean> contractOwnerOptions = new ArrayList<LabelValueBean>();
        contractOwnerOptions.add(new SelectOneLabelValueBean(this.requestContext, "0"));
        contractOwnerOptions.addAll(AdminUtils.getUserOptions(this.requestContext));
        ArrayList<LabelValueBean> companyOptions = new ArrayList<LabelValueBean>();
        companyOptions.add(new SelectOneLabelValueBean(this.requestContext, "0"));
        companyOptions.addAll(CompanyUtils.getCompanyOptions(this.requestContext));
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("contract", contract);
        standardTemplate.setPathAttribute("formAction", AppPaths.CONTRACTS_ADD_2);
        standardTemplate.setPathAttribute("formThisAction", AppPaths.CONTRACTS_ADD);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.CONTRACTS_LIST).getString());
        standardTemplate.setAttribute("contractTypeOptions", typeOptions);
        standardTemplate.setAttribute("contractStageOptions", contractStageOptions);
        standardTemplate.setAttribute("contractOwnerOptions", contractOwnerOptions);
        standardTemplate.setAttribute("contractRenewalTypeOptions", renewalOptions);
        standardTemplate.setAttribute("dateOptions", CalendarUtils.getDateOptions(this.requestContext));
        standardTemplate.setAttribute("monthOptions", CalendarUtils.getMonthOptions(this.requestContext));
        standardTemplate.setAttribute("yearOptions", CalendarUtils.getYearOptions(this.requestContext));
        standardTemplate.setAttribute("contractProviderOptions", companyOptions);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("itMgmt.contractAdd.title");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.CONTRACT);
        customFieldsTemplate.setObjectAttrTypeId(actionForm.getContractType());
        customFieldsTemplate.setForm(actionForm);
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        ContractForm actionForm = this.saveActionForm(new ContractForm());
        Contract contract = new Contract();
        contract.setName(actionForm.getContractName());
        contract.setDescription(actionForm.getContractDescription());
        contract.setOwnerId(actionForm.getContractOwner());
        contract.setType(actionForm.getContractType());
        contract.setStage(actionForm.getContractStage());
        contract.setContractProviderId(actionForm.getContractProviderId());
        contract.setEffectiveDateYear(actionForm.getContractEffectiveDateYear());
        contract.setEffectiveDateMonth(actionForm.getContractEffectiveDateMonth());
        contract.setEffectiveDateDate(actionForm.getContractEffectiveDateDate());
        contract.setExpireDateYear(actionForm.getContractExpirationDateYear());
        contract.setExpireDateMonth(actionForm.getContractExpirationDateMonth());
        contract.setExpireDateDate(actionForm.getContractExpirationDateDate());
        contract.setRenewalDateYear(actionForm.getContractRenewalDateYear());
        contract.setRenewalDateMonth(actionForm.getContractRenewalDateMonth());
        contract.setRenewalDateDate(actionForm.getContractRenewalDateDate());
        contract.setRenewalType(actionForm.getContractRenewalType());
        Map<Integer, Attribute> customAttributes = new AttributeManager(this.requestContext).populateCustomFieldValues(actionForm, contract);
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        ActionMessages errors = contractService.addContract(contract, customAttributes);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTRACTS_ADD + "?" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.CONTRACTS_DETAIL + "?contractId=" + contract.getId());
    }
}

