/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contracts;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.contacts.ContactAssociateForm;
import com.kwoksys.action.contacts.ContactAssociateTemplate;
import com.kwoksys.action.contracts.ContractForm;
import com.kwoksys.action.contracts.ContractSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.core.ContactUtils;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.contracts.ContractService;
import com.kwoksys.biz.contracts.core.ContractUtils;
import com.kwoksys.biz.contracts.dto.Contract;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.dto.linking.ContractContactLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import java.util.Arrays;
import java.util.List;

public class ContractContactsAction
extends Action2 {
    public String list() throws Exception {
        Link link;
        this.getBaseForm(ContactAssociateForm.class);
        AccessUser accessUser = this.requestContext.getUser();
        Integer contractId = this.requestContext.getParameter("contractId");
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(contractId);
        List<String> columnHeaders = Arrays.asList("contact_first_name", "contact_last_name", "contact_email_primary", "relationship_description");
        String orderBy = "contact_first_name";
        String order = "asc";
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(ContactQueries.getOrderByColumn(orderBy));
        List<Contact> contacts = contractService.getContractContacts(queryCriteria, contract.getId());
        List<DataRow> dataList = ContactUtils.formatContacts(this.requestContext, contacts, columnHeaders, new Counter());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.contractDetail.header", new Object[]{contract.getName()});
        if (Access.hasPermission(accessUser, AppPaths.CONTRACTS_CONTACT_ADD)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTRACTS_CONTACT_ADD + "?contractId=" + contract.getId());
            link.setTitleKey("common.linking.linkContacts");
            header.addHeaderCmds(link);
        }
        link = new Link(this.requestContext);
        link.setAjaxPath(AppPaths.CONTRACTS_LIST);
        link.setTitleKey("itMgmt.cmd.contractList");
        header.addHeaderCmds(link);
        standardTemplate.addTemplate(new ContractSpecTemplate(contract));
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(ContractUtils.contractTabList(this.requestContext, contract));
        tabs.setTabActive("contactsTab");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setDataList(dataList);
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setFormRemoveItemAction(AppPaths.CONTRACTS_CONTACT_REMOVE_2);
        tableTemplate.getFormHiddenVariableMap().put("contractId", String.valueOf(contract.getId()));
        tableTemplate.setFormRowIdName("contactId");
        tableTemplate.setEmptyRowMsgKey("contactMgmt.contactList.emptyTableMessage");
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add() throws Exception {
        ContractForm actionForm = this.getBaseForm(ContractForm.class);
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(actionForm.getContractId());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("contractId", contract.getId());
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.contractDetail.header", new Object[]{contract.getName()});
        standardTemplate.addTemplate(new ContractSpecTemplate(contract));
        ContactAssociateTemplate associateTemplate = standardTemplate.addTemplate(new ContactAssociateTemplate());
        associateTemplate.setFormContactId(actionForm.getFormContactId());
        associateTemplate.setFormSearchAction(AppPaths.CONTRACTS_CONTACT_ADD + "?contractId=" + contract.getId());
        associateTemplate.setFormSaveAction(AppPaths.CONTRACTS_CONTACT_ADD_2 + "?contractId=" + contract.getId());
        associateTemplate.setFormCancelAction(AppPaths.CONTRACTS_CONTACTS + "?contractId=" + contract.getId());
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add2() throws Exception {
        ContractForm actionForm = this.saveActionForm(new ContractForm());
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(actionForm.getContractId());
        ContractContactLink link = new ContractContactLink();
        link.setContractId(contract.getId());
        link.setContactId(actionForm.getContactId());
        link.setRelDescription(actionForm.getRelationshipDescription());
        ActionMessages errors = contractService.addContractContact(link);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTRACTS_CONTACT_ADD + "?contractId=" + contract.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.CONTRACTS_CONTACTS + "?contractId=" + contract.getId());
    }

    public String remove2() throws Exception {
        ContractForm actionForm = this.saveActionForm(new ContractForm());
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(actionForm.getContractId());
        ContractContactLink link = new ContractContactLink();
        link.setContractId(contract.getId());
        link.setContactId(actionForm.getContactId());
        ActionMessages errors = contractService.deleteContractContact(link);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTRACTS_CONTACTS + "?contractId=" + actionForm.getContractId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.CONTRACTS_CONTACTS + "?contractId=" + actionForm.getContractId());
    }
}

