/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contracts;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.contracts.ContractForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.CalendarUtils;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contracts.ContractService;
import com.kwoksys.biz.contracts.dto.Contract;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import com.kwoksys.framework.util.NumberUtils;
import java.util.ArrayList;
import java.util.Map;

public class ContractEditAction
extends Action2 {
    public String edit() throws Exception {
        ContractForm actionForm = this.getBaseForm(ContractForm.class);
        actionForm.setId("contractAddForm");
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(actionForm.getContractId());
        contract.loadAttrs(this.requestContext);
        if (!actionForm.isResubmit()) {
            actionForm.setContract(contract);
        }
        int effectiveDateYear = NumberUtils.replaceNull(actionForm.getContractEffectiveDateYear(), 0);
        int expirationDateYear = NumberUtils.replaceNull(actionForm.getContractExpirationDateYear(), 0);
        int renewalDateYear = NumberUtils.replaceNull(actionForm.getContractRenewalDateYear(), 0);
        ArrayList<LabelValueBean> companyOptions = new ArrayList<LabelValueBean>();
        companyOptions.add(new SelectOneLabelValueBean(this.requestContext, "0"));
        companyOptions.addAll(CompanyUtils.getCompanyOptions(this.requestContext));
        ArrayList<LabelValueBean> contractOwnerOptions = new ArrayList<LabelValueBean>();
        contractOwnerOptions.add(new SelectOneLabelValueBean(this.requestContext, "0"));
        contractOwnerOptions.addAll(AdminUtils.getUserOptions(this.requestContext, contract.getOwnerId()));
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        this.request.setAttribute("contract", (Object)contract);
        standardTemplate.setPathAttribute("formAction", AppPaths.CONTRACTS_EDIT_2 + "?contractId=" + actionForm.getContractId());
        standardTemplate.setPathAttribute("formThisAction", AppPaths.CONTRACTS_EDIT);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.CONTRACTS_DETAIL + "?contractId=" + actionForm.getContractId()).getString());
        standardTemplate.setAttribute("contractTypeOptions", new AttributeManager(this.requestContext).setOptional(true).setSelectedAttrFieldId(contract.getType()).getActiveAttrFieldOptionsCache(Attributes.CONTRACT_TYPE));
        standardTemplate.setAttribute("contractStageOptions", new AttributeManager(this.requestContext).setOptional(true).setSelectedAttrFieldId(contract.getStage()).getActiveAttrFieldOptionsCache(Attributes.CONTRACT_STAGE));
        standardTemplate.setAttribute("contractRenewalTypeOptions", new AttributeManager(this.requestContext).setOptional(true).setSelectedAttrFieldId(contract.getRenewalType()).getActiveAttrFieldOptionsCache(Attributes.CONTRACT_RENEWAL_TYPE));
        this.request.setAttribute("contractOwnerOptions", contractOwnerOptions);
        this.request.setAttribute("dateOptions", CalendarUtils.getDateOptions(this.requestContext));
        this.request.setAttribute("monthOptions", CalendarUtils.getMonthOptions(this.requestContext));
        this.request.setAttribute("effectiveYearOptions", CalendarUtils.getExtraYearOptions(this.requestContext, effectiveDateYear));
        this.request.setAttribute("expirationYearOptions", CalendarUtils.getExtraYearOptions(this.requestContext, expirationDateYear));
        this.request.setAttribute("renewalYearOptions", CalendarUtils.getExtraYearOptions(this.requestContext, renewalDateYear));
        this.request.setAttribute("contractProviderOptions", companyOptions);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("itMgmt.cmd.contractEdit");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.CONTRACT);
        customFieldsTemplate.setObjectId(actionForm.getContractId());
        customFieldsTemplate.setObjectAttrTypeId(actionForm.getContractType());
        customFieldsTemplate.setForm(actionForm);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        ContractForm actionForm = this.saveActionForm(new ContractForm());
        Contract contract = new Contract();
        contract.setId(actionForm.getContractId());
        contract.setName(actionForm.getContractName());
        contract.setDescription(actionForm.getContractDescription());
        contract.setOwnerId(actionForm.getContractOwner());
        contract.setType(actionForm.getContractType());
        contract.setStage(actionForm.getContractStage());
        contract.setContractProviderId(actionForm.getContractProviderId());
        contract.setEffectiveDateYear(actionForm.getContractEffectiveDateYear());
        contract.setEffectiveDateMonth(actionForm.getContractEffectiveDateMonth());
        contract.setEffectiveDateDate(actionForm.getContractEffectiveDateDate());
        contract.setExpireDateYear(actionForm.getContractExpirationDateYear());
        contract.setExpireDateMonth(actionForm.getContractExpirationDateMonth());
        contract.setExpireDateDate(actionForm.getContractExpirationDateDate());
        contract.setRenewalDateYear(actionForm.getContractRenewalDateYear());
        contract.setRenewalDateMonth(actionForm.getContractRenewalDateMonth());
        contract.setRenewalDateDate(actionForm.getContractRenewalDateDate());
        contract.setRenewalType(actionForm.getContractRenewalType());
        Map<Integer, Attribute> customAttributes = new AttributeManager(this.requestContext).populateCustomFieldValues(actionForm, contract);
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        ActionMessages errors = contractService.updateContract(contract, customAttributes);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTRACTS_EDIT + "?contractId=" + contract.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.CONTRACTS_DETAIL + "?contractId=" + contract.getId());
    }
}

