/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contracts;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.contracts.ContractSpecTemplate;
import com.kwoksys.action.files.FileAddTemplate;
import com.kwoksys.action.files.FileDeleteTemplate;
import com.kwoksys.action.files.FileEditTemplate;
import com.kwoksys.action.files.FileUploadForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.contracts.ContractService;
import com.kwoksys.biz.contracts.dto.Contract;
import com.kwoksys.biz.contracts.dto.ContractFile;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import java.io.FileNotFoundException;

public class ContractFileAction
extends Action2 {
    public String add() throws Exception {
        Integer contractId = this.requestContext.getParameter("contractId");
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(contractId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.contractDetail.header", new Object[]{contract.getName()});
        standardTemplate.addTemplate(new ContractSpecTemplate(contract));
        FileAddTemplate fileAdd = standardTemplate.addTemplate(new FileAddTemplate(this.getBaseForm(FileUploadForm.class)));
        fileAdd.setFileName(this.requestContext.getParameterString("fileName0"));
        fileAdd.setFormAction(AppPaths.CONTRACTS_FILE_ADD_2 + "?contractId=" + contractId);
        fileAdd.setFormCancelAction(AppPaths.CONTRACTS_DETAIL + "?contractId=" + contractId);
        fileAdd.getErrorsTemplate().setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add2() throws Exception {
        Integer contractId = this.requestContext.getParameter("contractId");
        FileUploadForm actionForm = this.getBaseForm(FileUploadForm.class);
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(contractId);
        ContractFile file = new ContractFile(contractId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        ActionMessages errors = fileService.addFile(file, actionForm);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.redirect(AppPaths.CONTRACTS_FILE_ADD + "?" + "_error=true" + "&contractId=" + contractId);
        }
        return this.redirect(AppPaths.CONTRACTS_DETAIL + "?contractId=" + contract.getId());
    }

    public String delete() throws Exception {
        Integer contractId = this.requestContext.getParameter("contractId");
        Integer fileId = this.requestContext.getParameter("fileId");
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(contractId);
        File file = contractService.getContractFile(contractId, fileId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("contractId", contractId);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.contractDetail.header", new Object[]{contract.getName()});
        standardTemplate.addTemplate(new ContractSpecTemplate(contract));
        FileDeleteTemplate fileDelete = standardTemplate.addTemplate(new FileDeleteTemplate());
        fileDelete.setFile(file);
        fileDelete.setFormAction(AppPaths.CONTRACTS_FILE_DELETE_2 + "?contractId=" + contractId + "&fileId=" + file.getId());
        fileDelete.setFormCancelAction(AppPaths.CONTRACTS_DETAIL + "?contractId=" + contractId);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String delete2() throws Exception {
        Integer contractId = this.requestContext.getParameter("contractId");
        Integer fileId = this.requestContext.getParameter("fileId");
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(contractId);
        File file = contractService.getContractFile(contract.getId(), fileId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        fileService.deleteFile(file);
        return this.ajaxUpdateView(AppPaths.CONTRACTS_DETAIL + "?contractId=" + contractId);
    }

    public String download() throws Exception {
        ResponseContext responseContext = new ResponseContext(this.response);
        try {
            Integer contractId = this.requestContext.getParameter("contractId");
            Integer fileId = this.requestContext.getParameter("fileId");
            ContractService contractService = ServiceProvider.getContractService(this.requestContext);
            contractService.getContract(contractId);
            File file = contractService.getContractFile(contractId, fileId);
            FileService fileService = ServiceProvider.getFileService(this.requestContext);
            fileService.download(responseContext, file);
        }
        catch (ObjectNotFoundException e) {
            throw new FileNotFoundException();
        }
        return null;
    }

    public String edit() throws Exception {
        Integer contractId = this.requestContext.getParameter("contractId");
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(contractId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = contractService.getContractFile(contractId, fileId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.contractDetail.header", new String[]{contract.getName()});
        standardTemplate.addTemplate(new ContractSpecTemplate(contract));
        FileEditTemplate fileEdit = standardTemplate.addTemplate(new FileEditTemplate());
        fileEdit.setFile(file);
        fileEdit.setFormAction(AppPaths.CONTRACTS_FILE_EDIT_2 + "?contractId=" + contractId + "&fileId=" + fileId);
        fileEdit.setFormCancelAction(AppPaths.CONTRACTS_DETAIL + "?contractId=" + contractId);
        ActionErrorsTemplate errorsTemplate = fileEdit.getErrorsTemplate();
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String edit2() throws Exception {
        FileUploadForm actionForm = this.saveActionForm(new FileUploadForm());
        Integer contractId = this.requestContext.getParameter("contractId");
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(contractId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = contractService.getContractFile(contract.getId(), fileId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        ActionMessages errors = fileService.updateFile(file, actionForm);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTRACTS_FILE_EDIT + "?contractId=" + contract.getId() + "&fileId=" + fileId + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.CONTRACTS_DETAIL + "?contractId=" + contractId);
    }
}

