/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contracts;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.contracts.ContractSearchForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contracts.ContractService;
import com.kwoksys.biz.contracts.core.ContractSearch;
import com.kwoksys.biz.contracts.core.ContractUtils;
import com.kwoksys.biz.contracts.dao.ContractQueries;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.List;

public class ContractListAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        ContractSearchForm actionForm = this.getSessionBaseForm(ContractSearchForm.class);
        String cmd = this.requestContext.getParameterString("cmd");
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "CONTRACTS_ORDER_BY", "contract_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "CONTRACTS_ORDER", "asc");
        int rowStart = 0;
        if (!cmd.isEmpty() || rowCmd.equals("showAll")) {
            this.request.getSession().setAttribute("CONTRACTS_ROW_START", (Object)rowStart);
        } else {
            rowStart = SessionManager.getOrSetAttribute(this.requestContext, "rowStart", "CONTRACTS_ROW_START", rowStart);
        }
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getContractsRowsToShow());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        ContractSearch contractSearch = new ContractSearch(this.requestContext, "CONTRACT_SEARCH_CRITERIA_MAP");
        contractSearch.prepareMap(actionForm);
        QueryCriteria queryCriteria = new QueryCriteria(contractSearch);
        int rowCount = contractService.getContractCount(queryCriteria);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        if (!contractSearch.getSearchCriteriaMap().isEmpty()) {
            standardTemplate.setAttribute("searchResultText", Localizer.getText(this.requestContext, "contracts.contractList.searchResult"));
        }
        standardTemplate.setAttribute("stageFilterOptions", new AttributeManager(this.requestContext).setOptional(true).getActiveAttrFieldOptionsCache(Attributes.CONTRACT_STAGE));
        standardTemplate.setPathAttribute("formAction", AppPaths.CONTRACTS_LIST);
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(ContractUtils.getColumnHeaderList());
        tableTemplate.setSortableColumnHeaders(ContractUtils.getSortableColumns());
        tableTemplate.setColumnPath(AppPaths.CONTRACTS_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setEmptyRowMsgKey("itMgmt.contractList.emptyTableMessage");
        if (rowCount != 0) {
            queryCriteria.setLimit(rowLimit, rowStart);
            if (ContractUtils.isSortableColumn(orderBy)) {
                queryCriteria.addSortColumn(ContractQueries.getOrderByColumn(orderBy), order);
            }
            List<DataRow> dataList = ContractUtils.fetchContractList(this.requestContext, queryCriteria, new Counter(rowStart));
            tableTemplate.setDataList(dataList);
        }
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("itMgmt.contractList.title");
        header.setTitleClassNoLine();
        if (Access.hasPermission(user, AppPaths.CONTRACTS_ADD)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTRACTS_ADD);
            link.setTitleKey("itMgmt.contractAdd.title");
            header.addHeaderCmds(link);
        }
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "contracts.contractList.rowCount", new Object[]{rowCount}));
        nav.setShowAllRecordsPath(AppPaths.CONTRACTS_LIST + "?rowCmd=showAll");
        nav.setPath(AppPaths.CONTRACTS_LIST + "?rowStart=");
        return standardTemplate.findTemplate("standard_template");
    }
}

