/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contracts;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableEmptyTemplate;
import com.kwoksys.action.common.template.TableHeaderTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.contracts.ContractRelationshipForm;
import com.kwoksys.action.contracts.ContractSpecTemplate;
import com.kwoksys.action.hardware.HardwareListTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contracts.ContractService;
import com.kwoksys.biz.contracts.core.ContractUtils;
import com.kwoksys.biz.contracts.dto.Contract;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.core.HardwareSearch;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.software.SoftwareSearch;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.SoftwareUtils;
import com.kwoksys.biz.software.dao.SoftwareQueries;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.dto.linking.ContractHardwareLink;
import com.kwoksys.biz.system.dto.linking.ContractSoftwareLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ContractRelationshipAction
extends Action2 {
    public String list() throws Exception {
        Link link;
        AccessUser accessUser = this.requestContext.getUser();
        Integer contractId = this.requestContext.getParameter("contractId");
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(contractId);
        this.getBaseForm(ContractRelationshipForm.class);
        String hwOrderBy = SessionManager.getOrSetAttribute(this.requestContext, "hwOrderBy", "HARDWARE_ORDER_BY", "hardware_name");
        String hwOrder = SessionManager.getOrSetAttribute(this.requestContext, "hwOrder", "HARDWARE_ORDER", "asc");
        boolean canRemoveHardware = Access.hasPermission(accessUser, AppPaths.CONTRACTS_HARDWARE_REMOVE_2);
        ArrayList<String> hwColumnHeaders = new ArrayList<String>();
        if (canRemoveHardware) {
            hwColumnHeaders.add("");
        }
        hwColumnHeaders.addAll(HardwareUtils.getColumnHeaderList());
        QueryCriteria queryCriteria = new QueryCriteria();
        if (HardwareUtils.isSortableColumn(hwOrderBy)) {
            queryCriteria.addSortColumn(HardwareQueries.getOrderByColumn(hwOrderBy), hwOrder);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("ajaxHardwareDetailPath", AppPaths.IT_MGMT_AJAX_GET_HARDWARE_DETAIL + "?hardwareId=");
        standardTemplate.setPathAttribute("formRemoveHardwareAction", AppPaths.CONTRACTS_HARDWARE_REMOVE_2);
        HardwareListTemplate listTemplate = standardTemplate.addTemplate(new HardwareListTemplate("_hardware"));
        listTemplate.setHardwareList(contractService.getContractHardwareList(queryCriteria, contractId));
        listTemplate.setCanRemoveHardware(canRemoveHardware);
        listTemplate.setColspan(hwColumnHeaders.size());
        listTemplate.setCounter(new Counter());
        listTemplate.getFormHiddenVariableMap().put("contractId", String.valueOf(contract.getId()));
        TableEmptyTemplate empty = standardTemplate.addTemplate(new TableEmptyTemplate("_hardware"));
        empty.setColSpan(hwColumnHeaders.size());
        empty.setRowText(Localizer.getText(this.requestContext, "itMgmt.hardwareList.emptyTableMessage"));
        TableHeaderTemplate tableHeader = standardTemplate.addTemplate(new TableHeaderTemplate("_hardware"));
        tableHeader.setColumnList(hwColumnHeaders);
        tableHeader.setSortableColumnList(HardwareUtils.getSortableColumns());
        tableHeader.setColumnPath(AppPaths.CONTRACTS_ITEMS + "?contractId=" + contractId);
        tableHeader.setColumnTextKey("common.column.");
        tableHeader.setOrderBy(hwOrderBy);
        tableHeader.setOrderByParamName("hwOrderBy");
        tableHeader.setOrderParamName("hwOrder");
        tableHeader.setOrder(hwOrder);
        String swOrderBy = SessionManager.getOrSetAttribute(this.requestContext, "swOrderBy", "SOFTWARE_ORDER_BY", "software_name");
        String swOrder = SessionManager.getOrSetAttribute(this.requestContext, "swOrder", "SOFTWARE_ORDER", "asc");
        QueryCriteria swQuery = new QueryCriteria();
        if (SoftwareUtils.isSortableColumn(swOrderBy)) {
            swQuery.addSortColumn(SoftwareQueries.getOrderByColumn(swOrderBy), swOrder);
        }
        List<Software> softwareList = contractService.getContractSoftwareList(swQuery, contractId);
        List<DataRow> formattedList = SoftwareUtils.formatSoftwareList(this.requestContext, softwareList, new Counter());
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate("_software"));
        tableTemplate.setDataList(formattedList);
        tableTemplate.setColumnHeaders(SoftwareUtils.getColumnHeaderList());
        tableTemplate.setColumnPath(AppPaths.CONTRACTS_ITEMS + "?contractId=" + contractId);
        tableTemplate.setSortableColumnHeaders(SoftwareUtils.getSortableColumns());
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setEmptyRowMsgKey("itMgmt.softwareList.emptyTableMessage");
        tableTemplate.setOrderBy(swOrderBy);
        tableTemplate.setOrder(swOrder);
        tableTemplate.setOrderByParamName("swOrderBy");
        tableTemplate.setOrderParamName("swOrder");
        tableTemplate.setFormRemoveItemAction(AppPaths.CONTRACTS_SOFTWARE_REMOVE_2);
        tableTemplate.getFormHiddenVariableMap().put("contractId", String.valueOf(contract.getId()));
        tableTemplate.setFormRowIdName("formSoftwareId");
        standardTemplate.addTemplate(new ContractSpecTemplate(contract));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.contractDetail.header", new Object[]{contract.getName()});
        if (Access.hasPermission(accessUser, AppPaths.CONTRACTS_HARDWARE_ADD)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTRACTS_HARDWARE_ADD + "?contractId=" + contractId);
            link.setTitleKey("common.linking.linkHardware");
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(accessUser, AppPaths.CONTRACTS_SOFTWARE_ADD)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTRACTS_SOFTWARE_ADD + "?contractId=" + contractId);
            link.setTitleKey("common.linking.linkSoftware");
            header.addHeaderCmds(link);
        }
        link = new Link(this.requestContext);
        link.setAjaxPath(AppPaths.CONTRACTS_LIST);
        link.setTitleKey("itMgmt.cmd.contractList");
        header.addHeaderCmds(link);
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(ContractUtils.contractTabList(this.requestContext, contract));
        tabs.setTabActive("hardwareTab");
        return standardTemplate.findTemplate("standard_template");
    }

    public String hardwareAdd() throws Exception {
        AccessUser user = this.requestContext.getUser();
        ContractRelationshipForm actionForm = this.getBaseForm(ContractRelationshipForm.class);
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(actionForm.getContractId());
        ArrayList hardwareList = new ArrayList();
        if (!actionForm.getFormHardwareId().isEmpty()) {
            HardwareSearch hardwareSearch = new HardwareSearch();
            hardwareSearch.put("hardwareIdEquals", actionForm.getFormHardwareId());
            List<Hardware> hardwareDataset = hardwareService.getHardwareList(new QueryCriteria(hardwareSearch));
            if (!hardwareDataset.isEmpty()) {
                boolean hasHardwareAccess = Access.hasPermission(user, AppPaths.HARDWARE_DETAIL);
                for (Hardware hardware : hardwareDataset) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("hardwareId", String.valueOf(hardware.getId()));
                    actionForm.setHardwareId(hardware.getId());
                    Link hardwareNameLink = new Link(this.requestContext);
                    hardwareNameLink.setTitle(hardware.getName());
                    if (hasHardwareAccess) {
                        hardwareNameLink.setAjaxPath(AppPaths.HARDWARE_DETAIL + "?hardwareId=" + hardware.getId());
                    }
                    map.put("hardwareName", hardwareNameLink.getString());
                    hardwareList.add(map);
                }
                this.request.setAttribute("hardwareList", hardwareList);
            }
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("contractId", actionForm.getContractId());
        standardTemplate.setPathAttribute("formSearchAction", AppPaths.CONTRACTS_HARDWARE_ADD + "?contractId=" + actionForm.getContractId());
        standardTemplate.setPathAttribute("formSaveAction", AppPaths.CONTRACTS_HARDWARE_ADD_2 + "?contractId=" + actionForm.getContractId());
        if (actionForm.getFormHardwareId().isEmpty()) {
            standardTemplate.setAttribute("selectHardwareMessage", "form.noSearchInput");
        } else if (hardwareList.isEmpty()) {
            standardTemplate.setAttribute("selectHardwareMessage", "form.noSearchResult");
        }
        if (hardwareList.isEmpty()) {
            standardTemplate.setAttribute("disableSaveButton", "disabled");
        }
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.CONTRACTS_ITEMS + "?contractId=" + actionForm.getContractId()).getString());
        standardTemplate.addTemplate(new ContractSpecTemplate(contract));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.contractDetail.header", new Object[]{contract.getName()});
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }

    public String hardwareAdd2() throws Exception {
        ContractRelationshipForm actionForm = this.getBaseForm(ContractRelationshipForm.class);
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(actionForm.getContractId());
        ContractHardwareLink contractHardware = new ContractHardwareLink();
        contractHardware.setContractId(actionForm.getContractId());
        contractHardware.setHardwareId(actionForm.getHardwareId());
        ActionMessages errors = contractService.addContractHardware(contractHardware);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTRACTS_HARDWARE_ADD + "?contractId=" + contract.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.CONTRACTS_ITEMS + "?contractId=" + contract.getId());
    }

    public String hardwareRemove2() throws Exception {
        Integer contractId = this.requestContext.getParameter("contractId");
        Integer hardwareId = this.requestContext.getParameter("formHardwareId");
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(contractId);
        ContractHardwareLink contractHardware = new ContractHardwareLink();
        contractHardware.setContractId(contract.getId());
        contractHardware.setHardwareId(hardwareId);
        contractService.deleteContractHardware(contractHardware);
        return this.ajaxUpdateView(AppPaths.CONTRACTS_ITEMS + "?contractId=" + contractId);
    }

    public String softwareAdd() throws Exception {
        AccessUser user = this.requestContext.getUser();
        ContractRelationshipForm actionForm = this.getBaseForm(ContractRelationshipForm.class);
        SoftwareService service = ServiceProvider.getSoftwareService(this.requestContext);
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(actionForm.getContractId());
        ArrayList formattedList = new ArrayList();
        if (!actionForm.getFormSoftwareId().isEmpty()) {
            SoftwareSearch softwareSearch = new SoftwareSearch();
            softwareSearch.put("softwareIdEquals", actionForm.getFormSoftwareId());
            List<Software> softwareList = service.getSoftwareList(new QueryCriteria(softwareSearch));
            if (!softwareList.isEmpty()) {
                boolean viewSoftwareDetail = Access.hasPermission(user, AppPaths.SOFTWARE_DETAIL);
                for (Software software : softwareList) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("softwareId", String.valueOf(software.getId()));
                    actionForm.setSoftwareId(software.getId());
                    Link link = new Link(this.requestContext);
                    link.setTitle(software.getName());
                    if (viewSoftwareDetail) {
                        link.setAjaxPath(AppPaths.SOFTWARE_DETAIL + "?softwareId=" + software.getId());
                    }
                    map.put("softwareName", link.getString());
                    formattedList.add(map);
                }
                this.request.setAttribute("softwareList", formattedList);
            }
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("contractId", actionForm.getContractId());
        standardTemplate.setPathAttribute("formSearchAction", AppPaths.CONTRACTS_SOFTWARE_ADD + "?contractId=" + actionForm.getContractId());
        standardTemplate.setPathAttribute("formSaveAction", AppPaths.CONTRACTS_SOFTWARE_ADD_2 + "?contractId=" + actionForm.getContractId());
        if (actionForm.getFormSoftwareId().isEmpty()) {
            standardTemplate.setAttribute("selectSoftwareMessage", "form.noSearchInput");
        } else if (formattedList.isEmpty()) {
            standardTemplate.setAttribute("selectSoftwareMessage", "form.noSearchResult");
        }
        if (formattedList.isEmpty()) {
            standardTemplate.setAttribute("disableSaveButton", "disabled");
        }
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.CONTRACTS_ITEMS + "?contractId=" + actionForm.getContractId()).getString());
        standardTemplate.addTemplate(new ContractSpecTemplate(contract));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.contractDetail.header", new Object[]{contract.getName()});
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }

    public String softwareAdd2() throws Exception {
        ContractRelationshipForm actionForm = this.getBaseForm(ContractRelationshipForm.class);
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(actionForm.getContractId());
        ContractSoftwareLink contractSoftware = new ContractSoftwareLink();
        contractSoftware.setContractId(actionForm.getContractId());
        contractSoftware.setSoftwareId(actionForm.getSoftwareId());
        ActionMessages errors = contractService.addContractSoftware(contractSoftware);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.CONTRACTS_SOFTWARE_ADD + "?contractId=" + contract.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.CONTRACTS_ITEMS + "?contractId=" + contract.getId());
    }

    public String softwareRemove2() throws Exception {
        Integer contractId = this.requestContext.getParameter("contractId");
        Integer softwareId = this.requestContext.getParameter("formSoftwareId");
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        Contract contract = contractService.getContract(contractId);
        ContractSoftwareLink map = new ContractSoftwareLink();
        map.setContractId(contract.getId());
        map.setSoftwareId(softwareId);
        contractService.deleteContractSoftware(map);
        return this.ajaxUpdateView(AppPaths.CONTRACTS_ITEMS + "?contractId=" + contractId);
    }
}

