/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contracts;

import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.contacts.core.CompanySearch;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import java.util.ArrayList;

public class ContractSearchTemplate
extends BaseTemplate {
    private String formAction;
    private boolean hideSearchButton;
    private String clearSearchLink;

    public ContractSearchTemplate() {
        super(ContractSearchTemplate.class);
    }

    @Override
    public void init() {
    }

    @Override
    public void applyTemplate() throws DatabaseException {
        ArrayList<LabelValueBean> providerOptions = new ArrayList<LabelValueBean>();
        providerOptions.add(new SelectOneLabelValueBean(this.requestContext, "0"));
        CompanySearch companySearch = new CompanySearch();
        companySearch.put("contractProviders", true);
        QueryCriteria queryCriteria = new QueryCriteria(companySearch);
        queryCriteria.addSortColumn("company_name");
        providerOptions.addAll(CompanyUtils.getCompanyOptions(this.requestContext, queryCriteria));
        this.request.setAttribute("customFieldsOptions", new AttributeManager(this.requestContext).getCustomFieldOptions(ObjectTypes.CONTRACT));
        this.request.setAttribute("contractTypeOptions", new AttributeManager(this.requestContext).setOptional(true).getAttrFieldOptionsCache(Attributes.CONTRACT_TYPE));
        this.request.setAttribute("contractStageOptions", new AttributeManager(this.requestContext).setOptional(true).getAttrFieldOptionsCache(Attributes.CONTRACT_STAGE));
        this.request.setAttribute("contractProviderOptions", providerOptions);
        if (!this.hideSearchButton) {
            this.clearSearchLink = new Link(this.requestContext).setAjaxPath(AppPaths.CONTRACTS_INDEX + "?cmd=clear").setTitleKey("common.form.clearCriteria").getString();
        }
    }

    public String getFormAction() {
        return this.formAction;
    }

    public void setFormAction(String formAction) {
        this.formAction = AppPaths.ROOT + formAction;
    }

    public boolean getHideSearchButton() {
        return this.hideSearchButton;
    }

    public void setHideSearchButton(boolean hideSearchButton) {
        this.hideSearchButton = hideSearchButton;
    }

    public String getClearSearchLink() {
        return this.clearSearchLink;
    }
}

