/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contracts;

import com.kwoksys.action.common.template.DetailTableTemplate;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.contracts.core.ContractUtils;
import com.kwoksys.biz.contracts.dto.Contract;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.ui.WidgetUtils;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.HtmlUtils;

public class ContractSpecTemplate
extends BaseTemplate {
    private DetailTableTemplate detailTableTemplate = new DetailTableTemplate();
    private Contract contract;
    private String headerText;
    private int columns = 2;

    public ContractSpecTemplate(Contract contract) {
        super(ContractSpecTemplate.class);
        this.contract = contract;
    }

    @Override
    public void init() {
        this.addTemplate(this.detailTableTemplate);
    }

    @Override
    public void applyTemplate() throws Exception {
        AccessUser user = this.requestContext.getUser();
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        this.detailTableTemplate.setNumColumns(this.columns);
        DetailTableTemplate.Td td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contract_id");
        td.setValue(String.valueOf(this.contract.getId()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contract_name");
        td.setValue(HtmlUtils.encode(this.contract.getName()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contract_description");
        td.setValue(HtmlUtils.formatMultiLineDisplay(this.contract.getDescription()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contract_type");
        td.setValue(HtmlUtils.encode(attributeManager.getAttrFieldNameCache(Attributes.CONTRACT_TYPE, this.contract.getType())));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contract_stage");
        td.setValue(attributeManager.getAttrFieldNameCache(Attributes.CONTRACT_STAGE, this.contract.getStage()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contract_owner");
        boolean canViewUserPage = Access.hasPermission(user, AppPaths.ADMIN_USER_DETAIL);
        if (this.contract.getOwnerId() != 0) {
            AccessUser contractOwner = new CacheManager(this.requestContext).getUserCache(this.contract.getOwnerId());
            StringBuilder contractOwnerMessage = new StringBuilder(Links.getUserIconLink(this.requestContext, contractOwner, canViewUserPage, true).getString());
            if (!contractOwner.hasPermission(12)) {
                contractOwnerMessage.append("<br><span class=\"infoContent\">*" + Localizer.getText(this.requestContext, "contracts.ownerNoPermissionForNotification") + "</span>");
            }
            td.setValue(contractOwnerMessage.toString());
        }
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contract_provider_name");
        td.setValue(Links.getCompanyDetailsLink(this.requestContext, this.contract.getContractProviderName(), this.contract.getContractProviderId()).getString());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contract_effective_date");
        td.setValue(DatetimeUtils.toShortDate(this.contract.getEffectiveDate()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contract_expiration_date");
        td.setValue(ContractUtils.formatExpirationDate(this.requestContext, this.requestContext.getSysdate(), this.contract.getExpireDate()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contract_renewal_date");
        td.setValue(DatetimeUtils.toShortDate(this.contract.getRenewalDate()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.contract_renewal_type");
        td.setValue(HtmlUtils.encode(attributeManager.getAttrFieldNameCache(Attributes.CONTRACT_RENEWAL_TYPE, this.contract.getRenewalType())));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.creator");
        AccessUser creatorUser = new CacheManager(this.requestContext).getUserCache(this.contract.getCreatorId());
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.contract.getCreationDate(), creatorUser));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.modifier");
        AccessUser modifierUser = new CacheManager(this.requestContext).getUserCache(this.contract.getModifierId());
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.contract.getModificationDate(), modifierUser));
        this.headerText = Localizer.getText(this.requestContext, "itMgmt.contractDetail.header", (Object[])new String[]{this.contract.getName()});
    }

    @Override
    public String getJspPath() {
        return "/jsp/contracts/ContractSpecTemplate.jsp";
    }

    public String getHeaderText() {
        return this.headerText;
    }
}

