/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.contracts;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.contracts.ContractSearchForm;
import com.kwoksys.action.contracts.ContractSearchTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.contracts.ContractService;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.NumberUtils;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class IndexAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        HttpSession session = this.request.getSession();
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        if (this.requestContext.getParameterString("cmd").equals("clear")) {
            session.setAttribute("CONTRACT_SEARCH_CRITERIA_MAP", null);
            this.clearSessionBaseForm(ContractSearchForm.class);
        }
        this.getSessionBaseForm(ContractSearchForm.class);
        boolean hasContractsAccess = user.hasPermission(AppPaths.CONTRACTS_LIST);
        ArrayList<String> links = new ArrayList<String>();
        if (hasContractsAccess) {
            if (session.getAttribute("CONTRACT_SEARCH_CRITERIA_MAP") != null) {
                links.add(new Link(this.requestContext).setAjaxPath(AppPaths.CONTRACTS_LIST).setTitleKey("common.search.showLastSearch").getString());
            }
            links.add(new Link(this.requestContext).setAjaxPath(AppPaths.CONTRACTS_LIST + "?cmd=showNonExpired").setTitleKey("contracts.filter.currentContracts").getString());
            links.add(new Link(this.requestContext).setAjaxPath(AppPaths.CONTRACTS_LIST + "?cmd=showAll").setTitleKey("contracts.filter.allContracts").getString());
        }
        Map<String, String> summary = contractService.getContractsSummary();
        ArrayList formattedSummary = new ArrayList();
        for (Map.Entry<String, String> entry : summary.entrySet()) {
            HashMap<String, String> formattedMap = new HashMap<String, String>();
            if (NumberUtils.replaceNull(entry.getValue()) <= 0) continue;
            formattedMap.put("text", Localizer.getText(this.requestContext, "contracts.search.expire_" + entry.getKey()));
            formattedMap.put("path", new Link(this.requestContext).setAjaxPath(AppPaths.CONTRACTS_LIST + "?cmd=groupBy&contractExpire=" + entry.getKey()).setEscapeTitle(entry.getValue()).getString());
            formattedSummary.add(formattedMap);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("contractFilters", links);
        standardTemplate.setAttribute("contractsSummary", formattedSummary);
        ContractSearchTemplate searchTemplate = standardTemplate.addTemplate(new ContractSearchTemplate());
        searchTemplate.setFormAction(AppPaths.CONTRACTS_LIST);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("core.moduleName.3");
        header.setTitleClassNoLine();
        header.setSectionKey("contracts.numContracts", new Integer[]{contractService.getContractCount(new QueryCriteria())});
        if (user.hasPermission(AppPaths.CONTRACTS_ADD)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.CONTRACTS_ADD);
            link.setTitleKey("itMgmt.contractAdd.title");
            header.addHeaderCmds(link);
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

