/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.files;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;

public class FileDeleteTemplate
extends BaseTemplate {
    private String formAction;
    private String formCancelAction;
    private File file;
    private String fileName;
    private String fileTitle;
    private String fileSize;

    public FileDeleteTemplate() {
        super(FileDeleteTemplate.class);
    }

    @Override
    public void init() {
        this.addTemplate(new ActionErrorsTemplate());
    }

    @Override
    public void applyTemplate() {
        this.fileName = this.file.getLogicalName();
        this.fileTitle = this.file.getTitle();
        this.fileSize = this.file.getFormattedFileSize(this.requestContext);
    }

    @Override
    public String getJspPath() {
        return "/jsp/files/FileDeleteTemplate.jsp";
    }

    public void setFormAction(String formAction) {
        this.formAction = AppPaths.ROOT + formAction;
    }

    public String getFormAction() {
        return this.formAction;
    }

    public String getFormCancelLink() {
        return Links.getCancelLink(this.requestContext, this.formCancelAction).getString();
    }

    public void setFormCancelAction(String formCancelAction) {
        this.formCancelAction = formCancelAction;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileTitle() {
        return this.fileTitle;
    }

    public String getFileSize() {
        return this.fileSize;
    }
}

