/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.files;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;

public class FileEditTemplate
extends BaseTemplate {
    private ActionErrorsTemplate errorsTemplate = new ActionErrorsTemplate();
    private String formAction;
    private String formCancelAction;
    private File file;
    private String fileName;
    private String fileTitle;
    private String fileSize;

    public FileEditTemplate() {
        super(FileEditTemplate.class);
    }

    @Override
    public void init() {
        this.addTemplate(this.errorsTemplate);
    }

    @Override
    public void applyTemplate() {
        this.fileName = this.file.getLogicalName();
        this.fileTitle = this.file.getTitle();
        this.fileSize = this.file.getFormattedFileSize(this.requestContext);
    }

    @Override
    public String getJspPath() {
        return "/jsp/files/FileEditTemplate.jsp";
    }

    public String getFormCancelLink() {
        return Links.getCancelLink(this.requestContext, this.formCancelAction).getString();
    }

    public String getFormAction() {
        return this.formAction;
    }

    public void setFormAction(String formAction) {
        this.formAction = AppPaths.ROOT + formAction;
    }

    public void setFormCancelAction(String formCancelAction) {
        this.formCancelAction = formCancelAction;
    }

    public String getFileTitle() {
        return this.fileTitle;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileSize() {
        return this.fileSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ActionErrorsTemplate getErrorsTemplate() {
        return this.errorsTemplate;
    }
}

