/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.hardware;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.hardware.HardwareForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.CalendarUtils;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.contacts.core.CompanySearch;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeFieldIds;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import java.util.ArrayList;
import java.util.Map;

public class HardwareAddAction
extends Action2 {
    public String add() throws Exception {
        Integer copyHardwareId = this.requestContext.getParameter("copyHardwareId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = copyHardwareId == 0 ? new Hardware() : hardwareService.getHardware(copyHardwareId);
        hardware.loadAttrs(this.requestContext);
        HardwareForm actionForm = this.getBaseForm(HardwareForm.class);
        actionForm.setId("hardwareAddForm");
        if (!actionForm.isResubmit()) {
            actionForm.setHardware(hardware);
        }
        SelectOneLabelValueBean selectOneLabel = new SelectOneLabelValueBean(this.requestContext, "0");
        ArrayList<LabelValueBean> hardwareOwnerOptions = new ArrayList<LabelValueBean>();
        hardwareOwnerOptions.add(new SelectOneLabelValueBean(this.requestContext));
        hardwareOwnerOptions.addAll(AdminUtils.getUserOptions(this.requestContext));
        ArrayList<LabelValueBean> hardwareVendors = new ArrayList<LabelValueBean>();
        hardwareVendors.add(selectOneLabel);
        CompanySearch vendorSearch = new CompanySearch();
        vendorSearch.put("companyTypeEquals", AttributeFieldIds.COMPANY_TYPE_HARDWARE_VENDOR);
        QueryCriteria vendorQuery = new QueryCriteria(vendorSearch);
        vendorQuery.addSortColumn("company_name");
        hardwareVendors.addAll(CompanyUtils.getCompanyOptions(this.requestContext, vendorQuery));
        ArrayList<LabelValueBean> hardwareManufacturers = new ArrayList<LabelValueBean>();
        hardwareManufacturers.add(selectOneLabel);
        CompanySearch manufacturerSearch = new CompanySearch();
        manufacturerSearch.put("companyTypeEquals", AttributeFieldIds.COMPANY_TYPE_HARDWARE_MANUFACTURER);
        QueryCriteria manufacturerQuery = new QueryCriteria(manufacturerSearch);
        manufacturerQuery.addSortColumn("company_name");
        hardwareManufacturers.addAll(CompanyUtils.getCompanyOptions(this.requestContext, manufacturerQuery));
        ArrayList<LabelValueBean> warrantyOptions = new ArrayList<LabelValueBean>();
        warrantyOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "hardware.selectWarrantyPeriod"), "0"));
        for (int i = 1; i <= 3; ++i) {
            String numYear = String.valueOf(i);
            warrantyOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "hardware.predefinedWarranty", (Object[])new String[]{numYear}), numYear));
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        this.request.setAttribute("hardware", (Object)hardware);
        standardTemplate.setPathAttribute("formAction", AppPaths.HARDWARE_ADD_2);
        standardTemplate.setPathAttribute("formThisAction", AppPaths.HARDWARE_ADD);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.HARDWARE_LIST).getString());
        standardTemplate.setAttribute("manufacturerHelpIcon", Links.getHelpIconLink(this.requestContext, "help.addHardwareManufacturer"));
        standardTemplate.setAttribute("vendorHelpIcon", Links.getHelpIconLink(this.requestContext, "help.addHardwareVendor"));
        this.request.setAttribute("currencySymbol", (Object)ConfigManager.system.getCurrencySymbol());
        this.request.setAttribute("purchaseYearOptions", CalendarUtils.getPastYearOptions(this.requestContext));
        this.request.setAttribute("purchaseMonthOptions", CalendarUtils.getMonthOptions(this.requestContext));
        this.request.setAttribute("purchaseDateOptions", CalendarUtils.getDateOptions(this.requestContext));
        this.request.setAttribute("warrantyYearOptions", CalendarUtils.getYearOptions(this.requestContext));
        this.request.setAttribute("warrantyMonthOptions", CalendarUtils.getMonthOptions(this.requestContext));
        this.request.setAttribute("warrantyDateOptions", CalendarUtils.getDateOptions(this.requestContext));
        this.request.setAttribute("hardwareOwnerOptions", hardwareOwnerOptions);
        this.request.setAttribute("manufacturersOptions", hardwareManufacturers);
        this.request.setAttribute("vendorsOptions", hardwareVendors);
        this.request.setAttribute("warrantyPeriodOptions", warrantyOptions);
        this.request.setAttribute("hardwareStatusOptions", new AttributeManager(this.requestContext).setOptional(true).getActiveAttrFieldOptionsCache(Attributes.HARDWARE_STATUS));
        this.request.setAttribute("hardwareTypeOptions", new AttributeManager(this.requestContext).setOptional(true).getActiveAttrFieldOptionsCache(Attributes.HARDWARE_TYPE));
        this.request.setAttribute("locationOptions", new AttributeManager(this.requestContext).setOptional(true).getActiveAttrFieldOptionsCache(Attributes.HARDWARE_LOCATION));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("itMgmt.cmd.hardwareAdd");
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.HARDWARE);
        if (copyHardwareId != 0) {
            customFieldsTemplate.setObjectId(copyHardwareId);
        }
        customFieldsTemplate.setObjectAttrTypeId(actionForm.getHardwareType());
        customFieldsTemplate.setForm(actionForm);
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        errorsTemplate.setMessageKey("itMgmt.hardwareAdd.sectionHeader");
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        HardwareForm actionForm = this.saveActionForm(new HardwareForm());
        Hardware hardware = new Hardware();
        hardware.setForm(actionForm);
        Map<Integer, Attribute> customAttributes = new AttributeManager(this.requestContext).populateCustomFieldValues(actionForm, hardware);
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        ActionMessages errors = hardwareService.addHardware(hardware, customAttributes);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.HARDWARE_ADD + "?" + "_error=true");
        }
        if (hardware.getOwnerId() != 0) {
            new CacheManager(this.requestContext).removeUserCache(hardware.getOwnerId());
        }
        return this.ajaxUpdateView(AppPaths.HARDWARE_DETAIL + "?hardwareId=" + hardware.getId());
    }
}

