/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.hardware;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableEmptyTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.hardware.HardwareComponentForm;
import com.kwoksys.action.hardware.HardwareSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.hardware.dto.HardwareComponent;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HardwareComponentsAction
extends Action2 {
    public String list() throws Exception {
        AccessUser user = this.requestContext.getUser();
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        boolean canEditComponent = user.hasPermission(AppPaths.HARDWARE_COMP_EDIT);
        boolean canDeleteComponent = user.hasPermission(AppPaths.HARDWARE_COMP_DELETE_2);
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        boolean hasCompCustomFields = adminService.hasCustomFields(ObjectTypes.HARDWARE_COMPONENT);
        ArrayList components = new ArrayList();
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(HardwareQueries.getOrderByColumn("attribute_field_name"));
        int colspan = 4;
        List<HardwareComponent> componentList = hardwareService.getHardwareComponents(queryCriteria, hardware.getId());
        if (!componentList.isEmpty()) {
            for (HardwareComponent component : componentList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("component", component);
                if (hasCompCustomFields) {
                    String onclickScript = "App.toggleCustomFieldsUpdate(this, 'cf" + component.getId() + "','" + AppPaths.ROOT + AppPaths.HARDWARE_AJAX_COMP_CUSTOM_FIELDS + "?hardwareId=" + hardwareId + "&compId=" + component.getId() + "','" + Localizer.getText(this.requestContext, "common.action.ToggleCollapse") + "', '" + Localizer.getText(this.requestContext, "common.action.ToggleExpand") + "')";
                    Link link = new Link(this.requestContext);
                    link.setInlineImage(Image.getInstance().getExpandIcon(this.requestContext, "common.action.ToggleExpand", "", onclickScript));
                    map.put("compPath", link.getString());
                }
                if (canEditComponent) {
                    map.put("editLink", new Link(this.requestContext).setTitleKey("common.action.Edit").setAjaxPath(AppPaths.HARDWARE_COMP_EDIT + "?hardwareId=" + hardwareId + "&compId=" + component.getId()));
                }
                components.add(map);
            }
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("hardwareId", hardwareId);
        standardTemplate.setAttribute("components", components);
        standardTemplate.setAttribute("colspan", colspan);
        standardTemplate.setAttribute("canEditComponent", canEditComponent);
        standardTemplate.setAttribute("canDeleteComponent", canDeleteComponent);
        standardTemplate.setPathAttribute("deletePath", AppPaths.HARDWARE_COMP_DELETE_2);
        if (componentList.isEmpty()) {
            TableEmptyTemplate empty = standardTemplate.addTemplate(new TableEmptyTemplate());
            empty.setColSpan(colspan);
            empty.setRowText(Localizer.getText(this.requestContext, "itMgmt.hardwareComp.emptyTableMessage"));
        }
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        HardwareUtils.addHardwareHeaderCommands(this.requestContext, header, hardwareId);
        if (user.hasPermission(AppPaths.HARDWARE_COMP_ADD)) {
            header.addHeaderCmds(new Link(this.requestContext).setTitleKey("itMgmt.cmd.hardwareComponentAdd").setAjaxPath(AppPaths.HARDWARE_COMP_ADD + "?hardwareId=" + hardwareId));
        }
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(HardwareUtils.hardwareTabList(hardware, this.requestContext));
        tabs.setTabActive("componentTab");
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }

    public String add() throws Exception {
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        HardwareComponent component = new HardwareComponent();
        HardwareComponentForm actionForm = this.getBaseForm(HardwareComponentForm.class);
        if (!actionForm.isResubmit()) {
            actionForm.setHardwareComponentType(component.getType());
            actionForm.setCompDescription(component.getDescription());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("hardwareId", hardwareId);
        standardTemplate.setPathAttribute("formAction", AppPaths.HARDWARE_COMP_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.HARDWARE_COMP + "?hardwareId=" + hardwareId).getString());
        standardTemplate.setAttribute("compOptions", new AttributeManager(this.requestContext).setOptional(true).getActiveAttrFieldOptionsCache(Attributes.HARDWARE_COMPONENT_TYPE));
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.HARDWARE_COMPONENT);
        customFieldsTemplate.setObjectId(component.getId());
        customFieldsTemplate.setForm(actionForm);
        customFieldsTemplate.setPartialTable(true);
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        HardwareComponentForm actionForm = this.saveActionForm(new HardwareComponentForm());
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(actionForm.getHardwareId());
        HardwareComponent component = new HardwareComponent();
        component.setHardwareId(hardware.getId());
        component.setType(actionForm.getHardwareComponentType());
        component.setDescription(actionForm.getCompDescription());
        Map<Integer, Attribute> customAttributes = new AttributeManager(this.requestContext).populateCustomFieldValues(actionForm, component);
        ActionMessages errors = hardwareService.addHardwareComponent(component, customAttributes);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.HARDWARE_COMP_ADD + "?hardwareId=" + hardware.getId() + "&" + "_error=true");
        }
        hardwareService.resetHardwareComponentCount(hardware.getId());
        return this.ajaxUpdateView(AppPaths.HARDWARE_COMP + "?hardwareId=" + component.getHardwareId());
    }

    public String edit() throws Exception {
        AccessUser user = this.requestContext.getUser();
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        Integer compId = this.requestContext.getParameter("compId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        HardwareComponent component = hardwareService.getHardwareComponent(hardwareId, compId);
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        HardwareComponentForm actionForm = this.getBaseForm(HardwareComponentForm.class);
        if (!actionForm.isResubmit()) {
            actionForm.setHardwareComponentType(component.getType());
            actionForm.setCompDescription(component.getDescription());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        this.request.setAttribute("hardwareId", (Object)hardwareId);
        standardTemplate.setPathAttribute("formAction", AppPaths.HARDWARE_COMP_EDIT_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.HARDWARE_COMP + "?hardwareId=" + hardwareId).getString());
        this.request.setAttribute("compId", (Object)component.getId());
        this.request.setAttribute("compOptions", attributeManager.getActiveAttrFieldOptionsCache(Attributes.HARDWARE_COMPONENT_TYPE));
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        if (Access.hasPermission(user, AppPaths.HARDWARE_LIST)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.HARDWARE_LIST);
            link.setTitleKey("itMgmt.cmd.hardwareList");
            header.addHeaderCmds(link);
        }
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.HARDWARE_COMPONENT);
        customFieldsTemplate.setObjectId(component.getId());
        customFieldsTemplate.setForm(actionForm);
        customFieldsTemplate.setPartialTable(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        HardwareComponentForm actionForm = this.saveActionForm(new HardwareComponentForm());
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        HardwareComponent component = hardwareService.getHardwareComponent(actionForm.getHardwareId(), actionForm.getCompId());
        component.setType(actionForm.getHardwareComponentType());
        component.setDescription(actionForm.getCompDescription());
        Map<Integer, Attribute> customAttributes = new AttributeManager(this.requestContext).populateCustomFieldValues(actionForm, component);
        ActionMessages errors = hardwareService.updateHardwareComponent(component, customAttributes);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.HARDWARE_COMP_EDIT + "?hardwareId=" + component.getHardwareId() + "&compId=" + component.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.HARDWARE_COMP + "?hardwareId=" + component.getHardwareId());
    }

    public String delete2() throws Exception {
        HardwareComponent component;
        HardwareComponentForm actionForm = this.saveActionForm(new HardwareComponentForm());
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        ActionMessages errors = hardwareService.deleteHardwareComponent(component = hardwareService.getHardwareComponent(actionForm.getHardwareId(), actionForm.getCompId()));
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.HARDWARE_COMP + "?hardwareId=" + component.getHardwareId() + "&" + "_error=true");
        }
        hardwareService.resetHardwareComponentCount(actionForm.getHardwareId());
        return this.ajaxUpdateView(AppPaths.HARDWARE_COMP + "?hardwareId=" + component.getHardwareId());
    }
}

