/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.hardware;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.contacts.ContactAssociateForm;
import com.kwoksys.action.contacts.ContactAssociateTemplate;
import com.kwoksys.action.hardware.HardwareForm;
import com.kwoksys.action.hardware.HardwareSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.core.ContactUtils;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.dto.linking.HardwareContactLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import java.util.Arrays;
import java.util.List;

public class HardwareContactsAction
extends Action2 {
    public String list() throws Exception {
        this.getBaseForm(ContactAssociateForm.class);
        AccessUser user = this.requestContext.getUser();
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "HARDWARE_CONTACTS_ORDER_BY", "contact_first_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "HARDWARE_CONTACTS_ORDER", "asc");
        List<String> columnHeaders = Arrays.asList("contact_first_name", "contact_last_name", "contact_email_primary", "relationship_description");
        QueryCriteria queryCriteria = new QueryCriteria();
        if (ContactUtils.isSortableColumn(orderBy)) {
            queryCriteria.addSortColumn(ContactQueries.getOrderByColumn(orderBy), order);
        }
        HardwareContactLink hardwareContact = new HardwareContactLink();
        hardwareContact.setHardwareId(hardwareId);
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        List<Contact> contacts = contactService.getLinkedContacts(queryCriteria, hardwareContact.createObjectMap());
        List<DataRow> dataList = ContactUtils.formatContacts(this.requestContext, contacts, columnHeaders, new Counter());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        HardwareUtils.addHardwareHeaderCommands(this.requestContext, header, hardwareId);
        if (Access.hasPermission(user, AppPaths.HARDWARE_CONTACT_ADD)) {
            Link link = new Link(this.requestContext).setAjaxPath(AppPaths.HARDWARE_CONTACT_ADD + "?hardwareId=" + hardwareId).setTitleKey("common.linking.linkContacts");
            header.addHeaderCmds(link);
        }
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(HardwareUtils.hardwareTabList(hardware, this.requestContext));
        tabs.setTabActive("contactTab");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setDataList(dataList);
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setSortableColumnHeaders(ContactUtils.getSortableContactColumnList());
        tableTemplate.setColumnPath(AppPaths.HARDWARE_CONTACTS + "?hardwareId=" + hardwareId);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(null);
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setEmptyRowMsgKey("contactMgmt.contactList.emptyTableMessage");
        tableTemplate.getFormHiddenVariableMap().put("hardwareId", String.valueOf(hardware.getId()));
        tableTemplate.setFormRowIdName("contactId");
        tableTemplate.setFormRemoveItemAction(AppPaths.HARDWARE_CONTACT_REMOVE);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add() throws Exception {
        HardwareForm actionForm = this.getBaseForm(HardwareForm.class);
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(actionForm.getHardwareId());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        ContactAssociateTemplate associateTemplate = standardTemplate.addTemplate(new ContactAssociateTemplate());
        associateTemplate.setFormContactId(actionForm.getFormContactId());
        associateTemplate.setFormSearchAction(AppPaths.HARDWARE_CONTACT_ADD + "?hardwareId=" + hardware.getId());
        associateTemplate.setFormSaveAction(AppPaths.HARDWARE_CONTACT_ADD_2 + "?hardwareId=" + hardware.getId());
        associateTemplate.setFormCancelAction(AppPaths.HARDWARE_CONTACTS + "?hardwareId=" + hardware.getId());
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add2() throws Exception {
        HardwareForm actionForm = this.saveActionForm(new HardwareForm());
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(actionForm.getHardwareId());
        HardwareContactLink hardwareContactLink = new HardwareContactLink();
        hardwareContactLink.setHardwareId(hardware.getId());
        hardwareContactLink.setContactId(Integer.valueOf(actionForm.getContactId()));
        hardwareContactLink.setRelDescription(actionForm.getRelationshipDescription());
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        ActionMessages errors = systemService.addObjectMapping(hardwareContactLink.createObjectMap());
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.HARDWARE_CONTACT_ADD + "?hardwareId=" + hardware.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.HARDWARE_CONTACTS + "?hardwareId=" + hardware.getId());
    }

    public String remove() throws Exception {
        HardwareForm actionForm = this.getBaseForm(HardwareForm.class);
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(actionForm.getHardwareId());
        HardwareContactLink hardwareContactLink = new HardwareContactLink();
        hardwareContactLink.setHardwareId(hardware.getId());
        hardwareContactLink.setContactId(Integer.valueOf(actionForm.getContactId()));
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        ActionMessages errors = systemService.deleteObjectMapping(hardwareContactLink.createObjectMap());
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.HARDWARE_CONTACTS + "?" + "_error=true" + "&hardwareId=" + hardware.getId());
        }
        return this.ajaxUpdateView(AppPaths.HARDWARE_CONTACTS + "?hardwareId=" + hardware.getId());
    }
}

