/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.hardware;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.ObjectDeleteTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.hardware.HardwareSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import java.util.List;

public class HardwareDeleteAction
extends Action2 {
    public String delete() throws Exception {
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        AccessUser user = this.requestContext.getUser();
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        if (Access.hasPermission(user, AppPaths.HARDWARE_LIST)) {
            Link link = new Link(this.requestContext).setAjaxPath(AppPaths.HARDWARE_LIST).setTitleKey("itMgmt.cmd.hardwareList");
            header.addHeaderCmds(link);
        }
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        ObjectDeleteTemplate delete = standardTemplate.addTemplate(new ObjectDeleteTemplate());
        delete.setFormAjaxAction(AppPaths.HARDWARE_DELETE_2 + "?hardwareId=" + hardwareId);
        delete.setFormCancelAction(AppPaths.HARDWARE_DETAIL + "?hardwareId=" + hardwareId);
        delete.setConfirmationMsgKey("itMgmt.hardwareDelete.confirm");
        delete.setSubmitButtonKey("itMgmt.hardwareDelete.submitButton");
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String delete2() throws Exception {
        List<Integer> hardwareIds = this.requestContext.getParameters("hardwareIds");
        boolean bulkDeleteSelected = !hardwareIds.isEmpty();
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        if (!bulkDeleteSelected) {
            Integer hardwareId = this.requestContext.getParameter("hardwareId");
            hardwareIds.add(hardwareId);
        }
        for (Integer deleteHardwareId : hardwareIds) {
            Hardware hardware = hardwareService.getHardware(deleteHardwareId);
            ActionMessages errors = hardwareService.deleteHardware(hardware);
            if (!errors.isEmpty()) {
                this.saveActionErrors(errors);
                if (bulkDeleteSelected) break;
                return this.ajaxUpdateView(AppPaths.HARDWARE_DELETE + "?hardwareId=" + hardware.getId() + "&" + "_error=true");
            }
            if (hardware.getOwnerId() == 0) continue;
            new CacheManager(this.requestContext).removeUserCache(hardware.getOwnerId());
        }
        return this.ajaxUpdateView(AppPaths.HARDWARE_LIST);
    }
}

