/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.hardware;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableEmptyTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.hardware.HardwareLicenseForm;
import com.kwoksys.action.hardware.HardwareSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.hardware.dto.HardwareSoftwareMap;
import com.kwoksys.biz.software.SoftwareUtils;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HardwareDetailAction
extends Action2 {
    public String execute() throws Exception {
        HardwareLicenseForm actionForm = this.getBaseForm(HardwareLicenseForm.class);
        AccessUser user = this.requestContext.getUser();
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(actionForm.getHardwareId());
        int colSpan = 4;
        ArrayList<LabelValueBean> softwareOptions = new ArrayList<LabelValueBean>();
        String formSoftwareLicense = AppPaths.IT_MGMT_AJAX_HARDWARE_ASSIGN_LICENSE + "?softwareId=";
        String cmd = actionForm.getCmd();
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn("software_name");
        queryCriteria.addSortColumn("license_key");
        List<HardwareSoftwareMap> maps = hardwareService.getInstalledLicense(queryCriteria, hardware.getId());
        ArrayList installedLicenses = new ArrayList();
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("softwareOptions", softwareOptions);
        standardTemplate.setPathAttribute("formAddLicAction", AppPaths.HARDWARE_LICENSE_ADD_2);
        standardTemplate.setAttribute("canRemoveLicense", user.hasPermission(AppPaths.HARDWARE_LICENSE_REMOVE_2));
        standardTemplate.setPathAttribute("formRemoveLicenseAction", AppPaths.HARDWARE_LICENSE_REMOVE_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.HARDWARE_DETAIL + "?hardwareId=" + hardware.getId()).getString());
        standardTemplate.setPathAttribute("formGetSoftwareLicenseAction", formSoftwareLicense);
        standardTemplate.setAttribute("colSpan", colSpan);
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.HARDWARE);
        customFieldsTemplate.setObjectId(hardware.getId());
        customFieldsTemplate.setObjectAttrTypeId(hardware.getType());
        customFieldsTemplate.setShowDefaultHeader(false);
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        HardwareUtils.addHardwareHeaderCommands(this.requestContext, headerTemplate, hardware.getId());
        headerTemplate.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        if (user.hasPermission(AppPaths.HARDWARE_LICENSE_ADD_2)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.HARDWARE_DETAIL + "?cmd=add&hardwareId=" + hardware.getId());
            link.setTitleKey("itMgmt.cmd.softwareLicenseAssign");
            headerTemplate.addHeaderCmds(link);
        }
        if (cmd.equals("add")) {
            queryCriteria = new QueryCriteria();
            queryCriteria.addSortColumn(HardwareQueries.getOrderByColumn("software_name"));
            List<Map<String, String>> softwareList = hardwareService.getAvailableSoftware(queryCriteria);
            for (Map<String, String> software : softwareList) {
                softwareOptions.add(new LabelValueBean(software.get("software_name").toString(), software.get("software_id").toString()));
            }
            if (!softwareList.isEmpty()) {
                LabelValueBean b = (LabelValueBean)softwareOptions.get(0);
                String softwareId = b.getValue();
                standardTemplate.getHeaderTemplate().setOnloadJavascript("App.updateView('softwareLicensesDiv', '" + AppPaths.ROOT + formSoftwareLicense + softwareId + "');");
            }
        }
        if (!maps.isEmpty()) {
            boolean viewSoftwareDetail = user.hasPermission(AppPaths.SOFTWARE_DETAIL);
            for (HardwareSoftwareMap map : maps) {
                HashMap<String, Object> datamap = new HashMap<String, Object>();
                datamap.put("mapId", map.getMapId());
                Link softwareLink = new Link(this.requestContext);
                softwareLink.setTitle(map.getSoftware().getName());
                if (viewSoftwareDetail) {
                    softwareLink.setAjaxPath(AppPaths.SOFTWARE_DETAIL + "?softwareId=" + map.getSoftwareId());
                }
                datamap.put("softwareName", softwareLink);
                String licenseKey = HtmlUtils.encode(map.getLicense().getKey());
                if (licenseKey.isEmpty()) {
                    licenseKey = Localizer.getText(this.requestContext, "itMgmt.hardwareDetail.unknownLicense");
                }
                datamap.put("licenseId", map.getLicenseId());
                datamap.put("licenseKey", licenseKey);
                datamap.put("licenseNote", SoftwareUtils.formatLicenseKey(map.getLicense().getNote()));
                if (!map.getLicenseId().equals(0) && user.hasPermission(AppPaths.SOFTWARE_AJAX_DETAILS)) {
                    String onclick = "App.toggleHardwareLicenseDetails('note" + map.getLicenseId() + "', '" + map.getLicenseId() + "', '" + AppPaths.ROOT + AppPaths.SOFTWARE_AJAX_DETAILS + "?softwareId=" + map.getSoftwareId() + "&licenseId=" + map.getLicenseId() + "', '" + Localizer.getText(this.requestContext, "common.action.ToggleCollapse") + "', '" + Localizer.getText(this.requestContext, "common.action.ToggleExpand") + "')";
                    datamap.put("licenseInfoLink", new Link(this.requestContext).setInlineImage(Image.getInstance().getExpandIcon(this.requestContext, "common.action.ToggleExpand", "toggleImg" + map.getLicenseId(), onclick)).getString());
                }
                installedLicenses.add(datamap);
            }
            standardTemplate.setAttribute("installedLicenses", installedLicenses);
        } else {
            TableEmptyTemplate empty = standardTemplate.addTemplate(new TableEmptyTemplate());
            empty.setColSpan(colSpan);
            empty.setRowText(Localizer.getText(this.requestContext, "itMgmt.hardwareDetail.emptyTableMessage"));
        }
        HardwareSpecTemplate tmpl = standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        tmpl.setPopulateLinkedContract(!cmd.equals("add"));
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(HardwareUtils.hardwareTabList(hardware, this.requestContext));
        tabs.setTabActive("licenseTab");
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }
}

