/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.hardware;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.hardware.HardwareForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.CalendarUtils;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.contacts.core.CompanySearch;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeFieldIds;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import com.kwoksys.framework.util.NumberUtils;
import java.util.ArrayList;
import java.util.Map;

public class HardwareEditAction
extends Action2 {
    public String edit() throws Exception {
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        hardware.loadAttrs(this.requestContext);
        HardwareForm actionForm = this.getBaseForm(HardwareForm.class);
        actionForm.setId("hardwareEditForm");
        if (!actionForm.isResubmit()) {
            actionForm.setHardware(hardware);
        }
        SelectOneLabelValueBean selectOneLabel = new SelectOneLabelValueBean(this.requestContext, "0");
        ArrayList<LabelValueBean> hardwareOwnerOptions = new ArrayList<LabelValueBean>();
        hardwareOwnerOptions.add(new SelectOneLabelValueBean(this.requestContext));
        hardwareOwnerOptions.addAll(AdminUtils.getUserOptions(this.requestContext, hardware.getOwnerId()));
        ArrayList<LabelValueBean> hardwareVendors = new ArrayList<LabelValueBean>();
        hardwareVendors.add(selectOneLabel);
        CompanySearch vendorSearch = new CompanySearch();
        vendorSearch.put("companyTypeEquals", AttributeFieldIds.COMPANY_TYPE_HARDWARE_VENDOR);
        vendorSearch.put("companyIdEquals", hardware.getVendorId());
        QueryCriteria vendorQuery = new QueryCriteria(vendorSearch);
        vendorQuery.addSortColumn("company_name");
        hardwareVendors.addAll(CompanyUtils.getCompanyOptions(this.requestContext, vendorQuery));
        ArrayList<LabelValueBean> hardwareManufacturers = new ArrayList<LabelValueBean>();
        hardwareManufacturers.add(selectOneLabel);
        CompanySearch manufacturerSearch = new CompanySearch();
        manufacturerSearch.put("companyTypeEquals", AttributeFieldIds.COMPANY_TYPE_HARDWARE_MANUFACTURER);
        manufacturerSearch.put("companyIdEquals", hardware.getManufacturerId());
        QueryCriteria manufacturerQuery = new QueryCriteria(manufacturerSearch);
        manufacturerQuery.addSortColumn("company_name");
        hardwareManufacturers.addAll(CompanyUtils.getCompanyOptions(this.requestContext, manufacturerQuery));
        int purchaseYear = NumberUtils.replaceNull(hardware.getPurchaseYear(), 0);
        int warrantyYear = NumberUtils.replaceNull(hardware.getWarrantyYear(), 0);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("hardware", hardware);
        standardTemplate.setPathAttribute("formAction", AppPaths.HARDWARE_EDIT_2);
        standardTemplate.setPathAttribute("formThisAction", AppPaths.HARDWARE_EDIT);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.HARDWARE_DETAIL + "?hardwareId=" + hardware.getId()).getString());
        standardTemplate.setAttribute("currencySymbol", ConfigManager.system.getCurrencySymbol());
        standardTemplate.setAttribute("locationOptions", new AttributeManager(this.requestContext).setOptional(true).setSelectedAttrFieldId(hardware.getLocation()).getActiveAttrFieldOptionsCache(Attributes.HARDWARE_LOCATION));
        standardTemplate.setAttribute("hardwareTypeOptions", new AttributeManager(this.requestContext).setOptional(true).setSelectedAttrFieldId(hardware.getType()).getActiveAttrFieldOptionsCache(Attributes.HARDWARE_TYPE));
        standardTemplate.setAttribute("hardwareStatusOptions", new AttributeManager(this.requestContext).setOptional(true).setSelectedAttrFieldId(hardware.getStatus()).getActiveAttrFieldOptionsCache(Attributes.HARDWARE_STATUS));
        standardTemplate.setAttribute("purchaseYearOptions", CalendarUtils.getExtraPastYearOptions(this.requestContext, purchaseYear));
        standardTemplate.setAttribute("warrantyYearOptions", CalendarUtils.getExtraYearOptions(this.requestContext, warrantyYear));
        standardTemplate.setAttribute("monthOptions", CalendarUtils.getMonthOptions(this.requestContext));
        standardTemplate.setAttribute("dateOptions", CalendarUtils.getDateOptions(this.requestContext));
        standardTemplate.setAttribute("hardwareOwnerOptions", hardwareOwnerOptions);
        standardTemplate.setAttribute("manufacturersOptions", hardwareManufacturers);
        standardTemplate.setAttribute("vendorsOptions", hardwareVendors);
        standardTemplate.setAttribute("manufacturerHelpIcon", Links.getHelpIconLink(this.requestContext, "help.addHardwareManufacturer"));
        standardTemplate.setAttribute("vendorHelpIcon", Links.getHelpIconLink(this.requestContext, "help.addHardwareVendor"));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("itMgmt.cmd.hardwareEdit");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        errorsTemplate.setMessageKey("itMgmt.hardwareEdit.sectionHeader");
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.HARDWARE);
        customFieldsTemplate.setObjectId(hardwareId);
        customFieldsTemplate.setObjectAttrTypeId(actionForm.getHardwareType());
        customFieldsTemplate.setForm(actionForm);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        HardwareForm actionForm = this.saveActionForm(new HardwareForm());
        Hardware hardware = hardwareService.getHardware(actionForm.getHardwareId());
        Integer currentHardwareOwnerId = hardware.getOwnerId();
        hardware.setForm(actionForm);
        Map<Integer, Attribute> customAttributes = new AttributeManager(this.requestContext).populateCustomFieldValues(actionForm, hardware);
        ActionMessages errors = hardwareService.updateHardware(hardware, customAttributes);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.HARDWARE_EDIT + "?hardwareId=" + hardware.getId() + "&" + "_error=true");
        }
        if (!currentHardwareOwnerId.equals(hardware.getOwnerId())) {
            if (currentHardwareOwnerId != 0) {
                new CacheManager(this.requestContext).removeUserCache(currentHardwareOwnerId);
            }
            if (hardware.getOwnerId() != 0) {
                new CacheManager(this.requestContext).removeUserCache(hardware.getOwnerId());
            }
        }
        return this.ajaxUpdateView(AppPaths.HARDWARE_DETAIL + "?hardwareId=" + hardware.getId());
    }
}

